/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.services;

public class ExponentialWeightedAverageForTimeWindow {
    private final long window;
    private double average;
    private long prevTime;

    public ExponentialWeightedAverageForTimeWindow(long window) {
        this.window = window;
    }

    public void addValueAtTime(double value, long time) {
        if (this.prevTime == 0L) {
            this.average = value;
        } else {
            double delta = time - this.prevTime;
            double alpha = 1.0 - Math.exp(-1.0 * delta / (double)this.window);
            this.average = alpha * value + (1.0 - alpha) * this.average;
        }
        this.prevTime = time;
    }

    public double getAverage() {
        return this.average;
    }
}

