/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.filters;

import java.util.List;
import org.onebusaway.siri.core.SiriLibrary;
import org.onebusaway.siri.core.filters.SiriModuleDeliveryFilter;
import uk.org.siri.siri.AbstractServiceDeliveryStructure;
import uk.org.siri.siri.ServiceDelivery;
import uk.org.siri.siri.VehicleMonitoringDeliveryStructure;

class VehicleMonitoringDeliveryFilter
implements SiriModuleDeliveryFilter {
    private String _directionRef;
    private String _lineRef;
    private String _vehicleRef;
    private String _vehicleMonitoringRef;
    private int _maximumVehicles = 0;

    VehicleMonitoringDeliveryFilter() {
    }

    public void setDirectionRef(String directionRef) {
        this._directionRef = directionRef;
    }

    public void setLineRef(String lineRef) {
        this._lineRef = lineRef;
    }

    public void setVehicleRef(String vehicleRef) {
        this._vehicleRef = vehicleRef;
    }

    public void setVehicleMonitoringRef(String vehicleMonitoringRef) {
        this._vehicleMonitoringRef = vehicleMonitoringRef;
    }

    public void setMaximumVehicles(int maximumVehicles) {
        this._maximumVehicles = maximumVehicles;
    }

    @Override
    public AbstractServiceDeliveryStructure filter(ServiceDelivery delivery, AbstractServiceDeliveryStructure moduleDelivery) {
        VehicleMonitoringDeliveryStructure vm = (VehicleMonitoringDeliveryStructure)moduleDelivery;
        List vasFiltered = vm.getVehicleActivity();
        if (this._vehicleMonitoringRef != null) {
            vasFiltered = SiriLibrary.grep(vasFiltered, "vehicleMonitoringRef.value", this._vehicleMonitoringRef);
        }
        if (this._directionRef != null) {
            vasFiltered = SiriLibrary.grep(vasFiltered, "monitoredVehicleJourney.directionRef.value", this._directionRef);
        }
        if (this._lineRef != null) {
            vasFiltered = SiriLibrary.grep(vasFiltered, "monitoredVehicleJourney.lineRef.value", this._lineRef);
        }
        if (this._vehicleRef != null) {
            vasFiltered = SiriLibrary.grep(vasFiltered, "monitoredVehicleJourney.vehicleRef.value", this._vehicleRef);
        }
        if (this._maximumVehicles > 0 && vasFiltered.size() > this._maximumVehicles) {
            while (vasFiltered.size() > this._maximumVehicles) {
                vasFiltered.remove(vasFiltered.size() - 1);
            }
        }
        if (vasFiltered.isEmpty()) {
            return null;
        }
        List vasOriginal = vm.getVehicleActivity();
        if (vasFiltered.size() < vasOriginal.size()) {
            SiriLibrary.copyList(vasFiltered, vasOriginal);
        }
        return vm;
    }
}

