/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.onebusaway.collections.tuple.T2;
import org.onebusaway.collections.tuple.Tuples;
import org.onebusaway.siri.core.ESiriModuleType;
import org.onebusaway.siri.core.exceptions.SiriException;
import org.onebusaway.siri.core.filters.SiriModuleDeliveryFilterMatcher;
import uk.org.siri.siri.AbstractSubscriptionStructure;
import uk.org.siri.siri.MessageQualifierStructure;
import uk.org.siri.siri.ParticipantRefStructure;
import uk.org.siri.siri.SubscriptionRequest;

public class SiriModuleDeliveryFilterMatcherFactoryImpl {
    private static final String ARG_MATCH_PREFIX = "Match.";
    private static final String ARG_MODULE_TYPE = "ModuleType";
    private static final Pattern _startsWithPattern = Pattern.compile("^StartsWith\\((.*)\\)$");
    private static final Pattern _endsWithPattern = Pattern.compile("^EndsWith\\((.*)\\)$");
    private static final Pattern _regexPattern = Pattern.compile("^Regex\\((.*)\\)$");
    private static final String EMPTY_VALUE_MATCHER = "Empty()";
    private static final Map<String, ValueExtractor> _valueExtractors = new HashMap<String, ValueExtractor>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("Address", new AddressExtractor());
            this.put("ConsumerAddress", new ConsumerAddressExtractor());
            this.put("SubscriptionFilterIdentifier", new SubscriptionFilterIdentifierExtractor());
            this.put("RequestorRef", new RequestorRefExtractor());
            this.put("MessageIdentifier", new MessageIdentifierExtractor());
        }
    };

    public SiriModuleDeliveryFilterMatcher create(Map<String, String> filterArgs) {
        ArrayList<T2> matchers = new ArrayList<T2>();
        Iterator<Map.Entry<String, String>> it = filterArgs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.startsWith(ARG_MATCH_PREFIX)) continue;
            it.remove();
            key = key.substring(ARG_MATCH_PREFIX.length());
            if (key.equals(ARG_MODULE_TYPE)) continue;
            ValueExtractor valueExtractor = _valueExtractors.get(key);
            ValueMatcher valueMatcher = this.getValueMatcherForValue(value);
            if (valueExtractor == null) {
                throw new SiriException("no matcher found for property \"" + key + "\"");
            }
            T2 tuple = Tuples.tuple((Object)valueExtractor, (Object)valueMatcher);
            matchers.add(tuple);
        }
        ESiriModuleType moduleType = null;
        String moduleTypeString = filterArgs.remove(ARG_MODULE_TYPE);
        if (moduleTypeString != null) {
            moduleType = ESiriModuleType.valueOf(moduleTypeString);
        }
        return new SiriModuleDeliveryFilterMatcherImpl(moduleType, new ArrayList<T2<ValueExtractor, ValueMatcher>>(matchers));
    }

    private ValueMatcher getValueMatcherForValue(String value) {
        Matcher m1 = _startsWithPattern.matcher(value);
        if (m1.matches()) {
            return new StartsWithMatcher(m1.group(1));
        }
        Matcher m2 = _endsWithPattern.matcher(value);
        if (m2.matches()) {
            return new EndsWithMatcher(m2.group(1));
        }
        Matcher m3 = _regexPattern.matcher(value);
        if (m3.matches()) {
            return new RegexMatcher(m3.group(1));
        }
        if (value.equals(EMPTY_VALUE_MATCHER)) {
            return new EmptyMatcher();
        }
        return new DirectMatcher(value);
    }

    private static class EmptyMatcher
    implements ValueMatcher {
        private EmptyMatcher() {
        }

        @Override
        public boolean isMatch(String argument) {
            return argument == null || argument.isEmpty();
        }
    }

    private static class RegexMatcher
    implements ValueMatcher {
        private final String _regex;

        public RegexMatcher(String regex) {
            this._regex = regex;
        }

        @Override
        public boolean isMatch(String argument) {
            return argument.matches(this._regex);
        }
    }

    private static class EndsWithMatcher
    implements ValueMatcher {
        private final String _suffix;

        public EndsWithMatcher(String suffix) {
            this._suffix = suffix;
        }

        @Override
        public boolean isMatch(String argument) {
            return argument.endsWith(this._suffix);
        }
    }

    private static class StartsWithMatcher
    implements ValueMatcher {
        private final String _prefix;

        public StartsWithMatcher(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public boolean isMatch(String argument) {
            return argument.startsWith(this._prefix);
        }
    }

    private static class DirectMatcher
    implements ValueMatcher {
        private final String _value;

        public DirectMatcher(String value) {
            this._value = value;
        }

        @Override
        public boolean isMatch(String argument) {
            return this._value.equals(argument);
        }
    }

    private static interface ValueMatcher {
        public boolean isMatch(String var1);
    }

    private static class MessageIdentifierExtractor
    implements ValueExtractor {
        private MessageIdentifierExtractor() {
        }

        @Override
        public String extractValue(SubscriptionRequest subscriptionRequest, ESiriModuleType moduleType, AbstractSubscriptionStructure moduleTypeSubscriptionRequest) {
            MessageQualifierStructure ref = subscriptionRequest.getMessageIdentifier();
            if (ref == null) {
                return null;
            }
            return ref.getValue();
        }
    }

    private static class RequestorRefExtractor
    implements ValueExtractor {
        private RequestorRefExtractor() {
        }

        @Override
        public String extractValue(SubscriptionRequest subscriptionRequest, ESiriModuleType moduleType, AbstractSubscriptionStructure moduleTypeSubscriptionRequest) {
            ParticipantRefStructure ref = subscriptionRequest.getRequestorRef();
            if (ref == null) {
                return null;
            }
            return ref.getValue();
        }
    }

    private static class SubscriptionFilterIdentifierExtractor
    implements ValueExtractor {
        private SubscriptionFilterIdentifierExtractor() {
        }

        @Override
        public String extractValue(SubscriptionRequest subscriptionRequest, ESiriModuleType moduleType, AbstractSubscriptionStructure moduleTypeSubscriptionRequest) {
            return subscriptionRequest.getSubscriptionFilterIdentifier();
        }
    }

    private static class ConsumerAddressExtractor
    implements ValueExtractor {
        private ConsumerAddressExtractor() {
        }

        @Override
        public String extractValue(SubscriptionRequest subscriptionRequest, ESiriModuleType moduleType, AbstractSubscriptionStructure moduleTypeSubscriptionRequest) {
            return subscriptionRequest.getConsumerAddress();
        }
    }

    private static class AddressExtractor
    implements ValueExtractor {
        private AddressExtractor() {
        }

        @Override
        public String extractValue(SubscriptionRequest subscriptionRequest, ESiriModuleType moduleType, AbstractSubscriptionStructure moduleTypeSubscriptionRequest) {
            return subscriptionRequest.getAddress();
        }
    }

    private static interface ValueExtractor {
        public String extractValue(SubscriptionRequest var1, ESiriModuleType var2, AbstractSubscriptionStructure var3);
    }

    private static class SiriModuleDeliveryFilterMatcherImpl
    implements SiriModuleDeliveryFilterMatcher {
        private final ESiriModuleType _moduleType;
        private final List<T2<ValueExtractor, ValueMatcher>> _matchers;

        public SiriModuleDeliveryFilterMatcherImpl(ESiriModuleType moduleType, List<T2<ValueExtractor, ValueMatcher>> matchers) {
            this._moduleType = moduleType;
            this._matchers = matchers;
        }

        @Override
        public boolean isMatch(SubscriptionRequest subscriptionRequest, ESiriModuleType moduleType, AbstractSubscriptionStructure moduleTypeSubscriptionRequest) {
            if (this._moduleType != null && this._moduleType != moduleType) {
                return false;
            }
            for (T2<ValueExtractor, ValueMatcher> tuple : this._matchers) {
                String value;
                ValueExtractor extractor = (ValueExtractor)tuple.getFirst();
                ValueMatcher matcher = (ValueMatcher)tuple.getSecond();
                if (matcher.isMatch(value = extractor.extractValue(subscriptionRequest, moduleType, moduleTypeSubscriptionRequest))) continue;
                return false;
            }
            return true;
        }
    }
}

