/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.filters;

import java.util.Iterator;
import java.util.Map;
import org.onebusaway.siri.core.exceptions.SiriException;
import org.onebusaway.siri.core.filters.ElementPathModuleDeliveryFilter;
import org.onebusaway.siri.core.filters.ModuleDeliveryFilterCollection;
import org.onebusaway.siri.core.filters.SiriModuleDeliveryFilter;

public class SiriModuleDeliveryFilterFactoryImpl {
    private static final String ARG_FILTER_PREFIX = "Filter.";
    private static final String ARG_FILTER_TYPE = "Filter.Type";
    private static final String ARG_FILTER_CLASS = "Filter.Class";
    private static final String ARG_FILTER_TYPE_ELEMENTS = "Elements";
    private static final String ARG_FILTER_ELEMENT_PREFIX = "Filter.Element.";

    public SiriModuleDeliveryFilter create(Map<String, String> filterArgs) {
        String filterType = filterArgs.remove(ARG_FILTER_TYPE);
        if (filterType != null) {
            if (filterType.equals(ARG_FILTER_TYPE_ELEMENTS)) {
                return this.createPropertyFilter(filterArgs);
            }
            throw new SiriException("uknown filter type: " + filterType);
        }
        String filterClassName = filterArgs.remove(ARG_FILTER_CLASS);
        if (filterClassName != null) {
            SiriModuleDeliveryFilter filter = (SiriModuleDeliveryFilter)this.createObjectForClassName(filterClassName);
            return filter;
        }
        throw new SiriException("expected argument \"Filter.Type\" or \"Filter.Class\"");
    }

    private SiriModuleDeliveryFilter createPropertyFilter(Map<String, String> filterArgs) {
        ModuleDeliveryFilterCollection collection = new ModuleDeliveryFilterCollection();
        Iterator<Map.Entry<String, String>> it = filterArgs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(ARG_FILTER_ELEMENT_PREFIX)) continue;
            it.remove();
            key = key.substring(ARG_FILTER_ELEMENT_PREFIX.length());
            String value = entry.getValue();
            ElementPathModuleDeliveryFilter filter = new ElementPathModuleDeliveryFilter(key, value);
            collection.addFilter(filter);
        }
        return collection;
    }

    private Object createObjectForClassName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (Throwable ex) {
            throw new SiriException("error instantiating class " + className, ex);
        }
    }
}

