/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.filters;

import java.math.BigInteger;
import org.onebusaway.siri.core.ESiriModuleType;
import org.onebusaway.siri.core.filters.SiriModuleDeliveryFilter;
import org.onebusaway.siri.core.filters.VehicleMonitoringDeliveryFilter;
import uk.org.siri.siri.AbstractServiceDeliveryStructure;
import uk.org.siri.siri.AbstractSubscriptionStructure;
import uk.org.siri.siri.DirectionRefStructure;
import uk.org.siri.siri.LineRefStructure;
import uk.org.siri.siri.ServiceDelivery;
import uk.org.siri.siri.VehicleMonitoringRefStructure;
import uk.org.siri.siri.VehicleMonitoringRequestStructure;
import uk.org.siri.siri.VehicleMonitoringSubscriptionStructure;
import uk.org.siri.siri.VehicleRefStructure;

public class ModuleDeliveryFilterFactory {
    private static final EmptyFilter _emptyFilter = new EmptyFilter();

    public SiriModuleDeliveryFilter createFilter(ESiriModuleType moduleType, AbstractSubscriptionStructure request) {
        switch (moduleType) {
            case VEHICLE_MONITORING: {
                return this.createVehicleMonitoringFilter((VehicleMonitoringSubscriptionStructure)request);
            }
        }
        return _emptyFilter;
    }

    private SiriModuleDeliveryFilter createVehicleMonitoringFilter(VehicleMonitoringSubscriptionStructure subscription) {
        VehicleMonitoringDeliveryFilter filter = new VehicleMonitoringDeliveryFilter();
        VehicleMonitoringRequestStructure vmRequest = subscription.getVehicleMonitoringRequest();
        if (vmRequest != null) {
            VehicleRefStructure vehicleRef;
            VehicleMonitoringRefStructure vmRef;
            BigInteger maxVehicles;
            LineRefStructure lineRef;
            DirectionRefStructure directionRef = vmRequest.getDirectionRef();
            if (directionRef != null && directionRef.getValue() != null) {
                filter.setDirectionRef(directionRef.getValue());
            }
            if ((lineRef = vmRequest.getLineRef()) != null && lineRef.getValue() != null) {
                filter.setLineRef(lineRef.getValue());
            }
            if ((maxVehicles = vmRequest.getMaximumVehicles()) != null && maxVehicles.intValue() > 0) {
                filter.setMaximumVehicles(maxVehicles.intValue());
            }
            if ((vmRef = vmRequest.getVehicleMonitoringRef()) != null && vmRef.getValue() != null) {
                filter.setVehicleMonitoringRef(vmRef.getValue());
            }
            if ((vehicleRef = vmRequest.getVehicleRef()) != null && vehicleRef.getValue() != null) {
                filter.setVehicleRef(vehicleRef.getValue());
            }
        }
        return filter;
    }

    private static class EmptyFilter
    implements SiriModuleDeliveryFilter {
        private EmptyFilter() {
        }

        @Override
        public AbstractServiceDeliveryStructure filter(ServiceDelivery delivery, AbstractServiceDeliveryStructure moduleDelivery) {
            return moduleDelivery;
        }
    }
}

