/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core.filters;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.onebusaway.siri.core.exceptions.SiriException;
import org.onebusaway.siri.core.filters.SiriModuleDeliveryFilter;
import org.onebusaway.siri.core.versioning.PropertyConverterSupport;
import uk.org.siri.siri.AbstractServiceDeliveryStructure;
import uk.org.siri.siri.ServiceDelivery;

public class ElementPathModuleDeliveryFilter
implements SiriModuleDeliveryFilter {
    private final String[] _propertyNames;
    private volatile PropertyDescriptor[] _properties = null;
    private final Object _value;

    public ElementPathModuleDeliveryFilter(String expression, Object value) {
        this._propertyNames = expression.split("\\.");
        for (int i = 0; i < this._propertyNames.length; ++i) {
            String name = this._propertyNames[i];
            this._propertyNames[i] = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        this._properties = new PropertyDescriptor[this._propertyNames.length];
        this._value = value;
    }

    @Override
    public AbstractServiceDeliveryStructure filter(ServiceDelivery delivery, AbstractServiceDeliveryStructure moduleDelivery) {
        this.traversePropertyPath(moduleDelivery, 0);
        return moduleDelivery;
    }

    private void traversePropertyPath(Object value, int depth) {
        PropertyDescriptor property = this.getPropertyDescriptorForDepth(value, depth);
        if (depth < this._propertyNames.length - 1) {
            Method readMethod = property.getReadMethod();
            Object subValue = PropertyConverterSupport.getSourcePropertyValue(value, readMethod);
            if (subValue == null) {
                return;
            }
            if (subValue instanceof Collection) {
                Collection collection = (Collection)subValue;
                for (Object element : collection) {
                    this.traversePropertyPath(element, depth + 1);
                }
            } else {
                this.traversePropertyPath(subValue, depth + 1);
            }
        } else {
            this.applyFilter(value, property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyDescriptor getPropertyDescriptorForDepth(Object value, int depth) {
        PropertyDescriptor property = this._properties[depth];
        if (property == null) {
            ElementPathModuleDeliveryFilter elementPathModuleDeliveryFilter = this;
            synchronized (elementPathModuleDeliveryFilter) {
                if (property == null) {
                    String propertyName = this._propertyNames[depth];
                    try {
                        BeanInfo beanInfo = Introspector.getBeanInfo(value.getClass());
                        for (PropertyDescriptor propertyDesc : beanInfo.getPropertyDescriptors()) {
                            if (!propertyDesc.getName().equals(propertyName)) continue;
                            property = propertyDesc;
                            break;
                        }
                    }
                    catch (Throwable ex) {
                        throw new SiriException("error in introspection of class " + value.getClass() + " and property \"" + propertyName + "\"");
                    }
                    if (property == null) {
                        throw new SiriException("class " + value.getClass() + " does not have property \"" + propertyName + "\"");
                    }
                    PropertyDescriptor[] properties = new PropertyDescriptor[this._properties.length];
                    System.arraycopy(this._properties, 0, properties, 0, properties.length);
                    properties[depth] = property;
                    this._properties = properties;
                }
            }
        }
        return property;
    }

    private void applyFilter(Object parent, PropertyDescriptor propertyDescriptor) {
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (writeMethod != null) {
            Class<?>[] parameterTypes = writeMethod.getParameterTypes();
            Class<?> parameterType = parameterTypes[0];
            Object value = this.convertValue(this._value, parameterType);
            PropertyConverterSupport.setTargetPropertyValue(parent, writeMethod, value);
        } else if (Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType()) && (this._value == null || this._value instanceof Collection)) {
            List values = (List)this._value;
            if (values == null) {
                values = Collections.emptyList();
            }
            PropertyConverterSupport.setTargetPropertyValues(parent, readMethod, values);
        } else {
            throw new SiriException("no write method for property \"" + propertyDescriptor.getName() + " on " + parent);
        }
    }

    private Object convertValue(Object value, Class<?> targetType) {
        if (value == null) {
            return value;
        }
        Class<?> existingType = value.getClass();
        if (targetType.isAssignableFrom(existingType)) {
            return value;
        }
        return ConvertUtils.convert((Object)value, targetType);
    }
}

