/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core;

import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.onebusaway.siri.core.SiriCommon;
import org.onebusaway.siri.core.exceptions.SiriConnectionException;
import org.onebusaway.siri.core.exceptions.SiriException;
import org.onebusaway.siri.core.handlers.SiriRawHandler;
import org.onebusaway.siri.core.handlers.SiriRequestResponseHandler;
import org.onebusaway.siri.core.handlers.SiriSubscriptionRequestHandler;
import org.onebusaway.siri.core.subscriptions.server.SiriServerSubscriptionEvent;
import org.onebusaway.siri.core.subscriptions.server.SiriServerSubscriptionManager;
import org.onebusaway.siri.core.versioning.ESiriVersion;
import org.onebusaway.siri.core.versioning.SiriVersioning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri.CheckStatusRequestStructure;
import uk.org.siri.siri.CheckStatusResponseStructure;
import uk.org.siri.siri.MessageQualifierStructure;
import uk.org.siri.siri.MessageRefStructure;
import uk.org.siri.siri.ServiceDelivery;
import uk.org.siri.siri.ServiceRequest;
import uk.org.siri.siri.Siri;
import uk.org.siri.siri.SubscriptionRequest;
import uk.org.siri.siri.SubscriptionResponseStructure;
import uk.org.siri.siri.TerminateSubscriptionRequestStructure;
import uk.org.siri.siri.TerminateSubscriptionResponseStructure;

@Singleton
public class SiriServer
extends SiriCommon
implements SiriRawHandler {
    private static Logger _log = LoggerFactory.getLogger(SiriServer.class);
    private SiriServerSubscriptionManager _subscriptionManager;
    private List<SiriRequestResponseHandler> _requestResponseHandlers = new ArrayList<SiriRequestResponseHandler>();
    private List<SiriSubscriptionRequestHandler> _subscriptionRequestHandlers = new ArrayList<SiriSubscriptionRequestHandler>();
    private long _serviceStartedTimestamp;
    private AtomicInteger _publishIncomingCount = new AtomicInteger();
    private AtomicInteger _publishOutgoingCount = new AtomicInteger();

    public SiriServer() {
        this.setUrl("http://*:8080/server.xml");
    }

    @Inject
    public void setSubscriptionManager(SiriServerSubscriptionManager subscriptionManager) {
        this._subscriptionManager = subscriptionManager;
    }

    public long getServiceStartedTimestamp() {
        return this._serviceStartedTimestamp;
    }

    public void addRequestResponseHandler(SiriRequestResponseHandler handler) {
        this._requestResponseHandlers.add(handler);
    }

    public void removeRequestResponseHandler(SiriRequestResponseHandler handler) {
        this._requestResponseHandlers.remove(handler);
    }

    public void addSubscriptionRequestHandler(SiriSubscriptionRequestHandler handler) {
        this._subscriptionRequestHandlers.add(handler);
    }

    public void removeSubscriptionRequestHandler(SiriSubscriptionRequestHandler handler) {
        this._subscriptionRequestHandlers.remove(handler);
    }

    @Override
    @PostConstruct
    public void start() {
        super.start();
        this._serviceStartedTimestamp = System.currentTimeMillis();
    }

    public int publish(ServiceDelivery serviceDelivery) {
        this._publishIncomingCount.incrementAndGet();
        this.fillServiceDelivery(serviceDelivery);
        List<SiriServerSubscriptionEvent> events = this._subscriptionManager.publish(serviceDelivery);
        _log.debug("server subscription events: {}", (Object)events.size());
        if (!events.isEmpty()) {
            this._publishOutgoingCount.addAndGet(events.size());
            for (SiriServerSubscriptionEvent event : events) {
                this._schedulingService.submit(new PublishEventTask(event));
            }
        }
        return events.size();
    }

    @Override
    public void handleRawRequest(Reader reader, Writer writer) {
        TerminateSubscriptionRequestStructure terminateSubscriptionRequest;
        CheckStatusRequestStructure checkStatusRequest;
        SubscriptionRequest subscriptionRequest;
        _log.debug("handling request");
        Object data = this.unmarshall(reader);
        SiriVersioning versioning = SiriVersioning.getInstance();
        ESiriVersion originalVersion = versioning.getVersionOfObject(data);
        data = versioning.getPayloadAsVersion(data, versioning.getDefaultVersion());
        if (!(data instanceof Siri)) {
            throw new SiriException("expected a " + Siri.class + " payload but instead received " + data.getClass());
        }
        Siri siri = (Siri)data;
        if (this.isRawDataLogged(siri)) {
            String requestContent = this.marshallToString(siri, true);
            _log.info("logging raw xml request:\n=== REQUEST BEGIN ===\n" + requestContent + "\n=== REQUEST END ===");
        }
        Siri siriResponse = new Siri();
        ServiceRequest serviceRequest = siri.getServiceRequest();
        if (serviceRequest != null) {
            ServiceDelivery serviceDelivery = this.handleServiceRequest(serviceRequest);
            siriResponse.setServiceDelivery(serviceDelivery);
        }
        if ((subscriptionRequest = siri.getSubscriptionRequest()) != null) {
            SubscriptionResponseStructure subscriptionResponse = this.handleSubscriptionRequest(subscriptionRequest, originalVersion);
            siriResponse.setSubscriptionResponse(subscriptionResponse);
        }
        if ((checkStatusRequest = siri.getCheckStatusRequest()) != null) {
            CheckStatusResponseStructure response = this.handleCheckStatusRequest(checkStatusRequest);
            siriResponse.setCheckStatusResponse(response);
        }
        if ((terminateSubscriptionRequest = siri.getTerminateSubscriptionRequest()) != null) {
            TerminateSubscriptionResponseStructure response = this.handleTerminateSubscriptionRequest(terminateSubscriptionRequest);
            siriResponse.setTerminateSubscriptionResponse(response);
        }
        this.fillAllSiriStructures(siriResponse);
        Object responseData = versioning.getPayloadAsVersion(siriResponse, originalVersion);
        if (this.isRawDataLogged(siri)) {
            String responseContent = this.marshallToString(responseData, true);
            _log.info("logging raw xml response:\n=== RESPONSE BEGIN ===\n" + responseContent + "\n=== RESPONSE END ===");
        }
        this.marshall(responseData, writer);
    }

    @Override
    public void getStatus(Map<String, String> status) {
        super.getStatus(status);
        status.put("siri.server.publishIncomingCounter", Integer.toString(this._publishIncomingCount.get()));
        status.put("siri.server.publishOutgoingCounter", Integer.toString(this._publishOutgoingCount.get()));
    }

    private SubscriptionResponseStructure handleSubscriptionRequest(SubscriptionRequest subscriptionRequest, ESiriVersion originalVersion) {
        _log.debug("handling SubscriptionRequest");
        for (SiriSubscriptionRequestHandler handler : this._subscriptionRequestHandlers) {
            handler.handleSubscriptionRequest(subscriptionRequest);
        }
        SubscriptionResponseStructure response = new SubscriptionResponseStructure();
        response.setServiceStartedTime(new Date(this._serviceStartedTimestamp));
        response.setRequestMessageRef(subscriptionRequest.getMessageIdentifier());
        List statuses = response.getResponseStatus();
        this._subscriptionManager.handleSubscriptionRequest(subscriptionRequest, originalVersion, statuses);
        return response;
    }

    private ServiceDelivery handleServiceRequest(ServiceRequest serviceRequest) {
        ServiceDelivery response = new ServiceDelivery();
        for (SiriRequestResponseHandler handler : this._requestResponseHandlers) {
            handler.handleRequestAndResponse(serviceRequest, response);
        }
        return response;
    }

    private CheckStatusResponseStructure handleCheckStatusRequest(CheckStatusRequestStructure request) {
        CheckStatusResponseStructure response = new CheckStatusResponseStructure();
        response.setStatus(Boolean.TRUE);
        MessageQualifierStructure messageId = request.getMessageIdentifier();
        if (messageId != null) {
            MessageRefStructure ref = new MessageRefStructure();
            ref.setValue(messageId.getValue());
            response.setRequestMessageRef(ref);
        }
        response.setServiceStartedTime(new Date(this._serviceStartedTimestamp));
        return response;
    }

    private TerminateSubscriptionResponseStructure handleTerminateSubscriptionRequest(TerminateSubscriptionRequestStructure request) {
        TerminateSubscriptionResponseStructure response = new TerminateSubscriptionResponseStructure();
        response.setRequestMessageRef(request.getMessageIdentifier());
        List statuses = response.getTerminationResponseStatus();
        this._subscriptionManager.terminateSubscriptionsForRequest(request, statuses);
        return response;
    }

    private void publishResponse(SiriServerSubscriptionEvent event) {
        String address = event.getAddress();
        ESiriVersion targetVersion = event.getTargetVersion();
        ServiceDelivery delivery = event.getDelivery();
        Siri siri = new Siri();
        siri.setServiceDelivery(delivery);
        this.fillAllSiriStructures(siri);
        SiriVersioning versioning = SiriVersioning.getInstance();
        Object data = versioning.getPayloadAsVersion(siri, targetVersion);
        String content = this.marshallToString(data);
        long tStart = System.currentTimeMillis();
        boolean connectionError = false;
        try {
            this.sendHttpRequest(address, content);
        }
        catch (SiriConnectionException ex) {
            _log.warn("error connecting to client at " + address, (Throwable)ex);
            connectionError = true;
        }
        long tStop = System.currentTimeMillis();
        this._subscriptionManager.recordPublicationStatistics(event, tStop - tStart, connectionError);
    }

    private class PublishEventTask
    implements Runnable {
        private final SiriServerSubscriptionEvent _event;

        public PublishEventTask(SiriServerSubscriptionEvent event) {
            this._event = event;
        }

        @Override
        public void run() {
            try {
                SiriServer.this.publishResponse(this._event);
            }
            catch (Throwable ex) {
                _log.warn("error publishing to " + this._event.getSubscriptionId(), ex);
            }
        }
    }
}

