/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.onebusaway.collections.PropertyPathExpression;
import org.onebusaway.siri.core.ESiriModuleType;
import org.onebusaway.siri.core.versioning.IntrospectionVersionConverter;
import org.onebusaway.siri.core.versioning.PackageBasedTypeMappingStrategy;
import org.onebusaway.siri.core.versioning.VersionConverter;
import uk.org.siri.siri.AbstractServiceDeliveryStructure;
import uk.org.siri.siri.AbstractServiceRequestStructure;
import uk.org.siri.siri.AbstractSubscriptionStructure;
import uk.org.siri.siri.HalfOpenTimestampRangeStructure;
import uk.org.siri.siri.PtSituationElementStructure;
import uk.org.siri.siri.RoadSituationElementStructure;
import uk.org.siri.siri.ServiceDelivery;
import uk.org.siri.siri.ServiceRequest;
import uk.org.siri.siri.Siri;
import uk.org.siri.siri.SubscriptionRequest;
import uk.org.siri.siri.WorkflowStatusEnumeration;

public class SiriLibrary {
    private static VersionConverter _copier;

    public static <T extends AbstractServiceRequestStructure> List<T> getServiceRequestsForModule(ServiceRequest serviceRequest, ESiriModuleType moduleType) {
        switch (moduleType) {
            case VEHICLE_MONITORING: {
                return serviceRequest.getVehicleMonitoringRequest();
            }
            case SITUATION_EXCHANGE: {
                return serviceRequest.getSituationExchangeRequest();
            }
        }
        return new ArrayList();
    }

    public static <T extends AbstractSubscriptionStructure> List<T> getSubscriptionRequestsForModule(SubscriptionRequest subscriptionRequest, ESiriModuleType moduleType) {
        switch (moduleType) {
            case VEHICLE_MONITORING: {
                return subscriptionRequest.getVehicleMonitoringSubscriptionRequest();
            }
            case SITUATION_EXCHANGE: {
                return subscriptionRequest.getSituationExchangeSubscriptionRequest();
            }
        }
        return new ArrayList();
    }

    public static <T extends AbstractServiceDeliveryStructure> List<T> getServiceDeliveriesForModule(ServiceDelivery serviceDelivery, ESiriModuleType moduleType) {
        switch (moduleType) {
            case VEHICLE_MONITORING: {
                return serviceDelivery.getVehicleMonitoringDelivery();
            }
            case SITUATION_EXCHANGE: {
                return serviceDelivery.getSituationExchangeDelivery();
            }
        }
        return new ArrayList();
    }

    public static <T> List<T> grep(Iterable<T> elements, String propertyPathExpression, Object equalityValue) {
        PropertyPathExpression ppe = new PropertyPathExpression(propertyPathExpression);
        ArrayList<T> matches = new ArrayList<T>();
        for (T element : elements) {
            Object value = ppe.invoke(element);
            if (!ObjectUtils.equals((Object)value, (Object)equalityValue)) continue;
            matches.add(element);
        }
        return matches;
    }

    public static Siri copy(Siri payload) {
        return (Siri)_copier.convert(payload);
    }

    public static AbstractServiceDeliveryStructure deepCopyModuleDelivery(ESiriModuleType moduleType, AbstractServiceDeliveryStructure from) {
        return (AbstractServiceDeliveryStructure)_copier.convert(from);
    }

    public static void copyServiceDelivery(AbstractServiceDeliveryStructure from, AbstractServiceDeliveryStructure to) {
        to.setDefaultLanguage(from.getDefaultLanguage());
        to.setErrorCondition(from.getErrorCondition());
        to.setRequestMessageRef(from.getRequestMessageRef());
        to.setResponseTimestamp(from.getResponseTimestamp());
        to.setShortestPossibleCycle(from.getShortestPossibleCycle());
        to.setStatus(from.isStatus());
        to.setSubscriberRef(from.getSubscriberRef());
        to.setSubscriptionFilterRef(from.getSubscriptionFilterRef());
        to.setSubscriptionRef(from.getSubscriptionRef());
        to.setValidUntil(from.getValidUntil());
    }

    public static <T> void copyList(List<T> from, List<T> to) {
        to.clear();
        to.addAll(from);
    }

    public static boolean isSituationClosed(PtSituationElementStructure situation) {
        WorkflowStatusEnumeration progress = situation.getProgress();
        return progress != null && (progress == WorkflowStatusEnumeration.CLOSING || progress == WorkflowStatusEnumeration.CLOSED);
    }

    public static boolean isSituationExpired(PtSituationElementStructure situation, Date currentTime) {
        HalfOpenTimestampRangeStructure publicationWindow = situation.getPublicationWindow();
        if (publicationWindow != null && SiriLibrary.isTimeRangeActiveOrUpcoming(publicationWindow, currentTime)) {
            return false;
        }
        List periods = situation.getValidityPeriod();
        if (periods != null) {
            for (RoadSituationElementStructure.ValidityPeriod period : periods) {
                if (!SiriLibrary.isTimeRangeActiveOrUpcoming((HalfOpenTimestampRangeStructure)period, currentTime)) continue;
                return false;
            }
        }
        return publicationWindow != null || periods != null && !periods.isEmpty();
    }

    public static boolean isSituationPublishedOrValid(PtSituationElementStructure situation, Date currentTime) {
        HalfOpenTimestampRangeStructure publicationWindow = situation.getPublicationWindow();
        if (publicationWindow != null && SiriLibrary.isTimeRangeActive(publicationWindow, currentTime)) {
            return true;
        }
        List periods = situation.getValidityPeriod();
        if (periods != null) {
            for (RoadSituationElementStructure.ValidityPeriod period : periods) {
                if (!SiriLibrary.isTimeRangeActive((HalfOpenTimestampRangeStructure)period, currentTime)) continue;
                return true;
            }
        }
        return publicationWindow == null && (periods == null || periods.isEmpty());
    }

    public static boolean isTimeRangeActive(HalfOpenTimestampRangeStructure range, Date time) {
        if (range.getStartTime() == null && range.getEndTime() == null) {
            return false;
        }
        boolean from = range.getStartTime() == null || !range.getStartTime().after(time);
        boolean to = range.getEndTime() == null || !range.getEndTime().before(time);
        return from && to;
    }

    public static boolean isTimeRangeActiveOrUpcoming(HalfOpenTimestampRangeStructure range, Date time) {
        if (range.getStartTime() == null && range.getEndTime() == null) {
            return false;
        }
        return range.getEndTime() == null || !time.after(range.getEndTime());
    }

    public static Map<String, String> getLineAsMap(String line) {
        String[] tokens = line.split(",");
        HashMap<String, String> subArgs = new HashMap<String, String>();
        for (String token : tokens) {
            int index = token.indexOf(61);
            if (index != -1) {
                String key = token.substring(0, index);
                String value = token.substring(index + 1);
                subArgs.put(key, value);
                continue;
            }
            subArgs.put(token, null);
        }
        return subArgs;
    }

    public static boolean needsHelp(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-h") && !arg.equals("--help") && !arg.equals("-help")) continue;
            return true;
        }
        return false;
    }

    static {
        PackageBasedTypeMappingStrategy selfMapping = new PackageBasedTypeMappingStrategy("uk.org.siri.siri", "uk.org.siri.siri");
        _copier = new IntrospectionVersionConverter(selfMapping);
    }
}

