/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.onebusaway.siri.core.ESiriModuleType;
import org.onebusaway.siri.core.SiriClientRequest;
import org.onebusaway.siri.core.SiriLibrary;
import org.onebusaway.siri.core.SiriTypeFactory;
import org.onebusaway.siri.core.exceptions.SiriConnectionException;
import org.onebusaway.siri.core.exceptions.SiriException;
import org.onebusaway.siri.core.exceptions.SiriSerializationException;
import org.onebusaway.siri.core.handlers.SiriRawHandler;
import org.onebusaway.siri.core.services.HttpClientService;
import org.onebusaway.siri.core.services.SchedulingService;
import org.onebusaway.siri.core.services.StatusProviderService;
import org.onebusaway.siri.core.versioning.SiriVersioning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri.AbstractFunctionalServiceRequestStructure;
import uk.org.siri.siri.AbstractRequestStructure;
import uk.org.siri.siri.AbstractSubscriptionStructure;
import uk.org.siri.siri.CheckStatusResponseStructure;
import uk.org.siri.siri.MessageQualifierStructure;
import uk.org.siri.siri.ProducerResponseStructure;
import uk.org.siri.siri.RequestStructure;
import uk.org.siri.siri.ResponseEndpointStructure;
import uk.org.siri.siri.ResponseStructure;
import uk.org.siri.siri.ServiceDelivery;
import uk.org.siri.siri.ServiceRequest;
import uk.org.siri.siri.Siri;
import uk.org.siri.siri.SubscriptionContextStructure;
import uk.org.siri.siri.SubscriptionRequest;
import uk.org.siri.siri.VehicleMonitoringSubscriptionStructure;

public class SiriCommon
implements SiriRawHandler,
StatusProviderService {
    private static Logger _log = LoggerFactory.getLogger(SiriCommon.class);
    private static DatatypeFactory _dataTypeFactory = SiriTypeFactory.createDataTypeFactory();
    private JAXBContext _jaxbContext;
    protected SchedulingService _schedulingService;
    protected HttpClientService _httpClientService;
    private DefaultHttpClient _client;
    private String _identity;
    private String _url;
    private String _privateUrl;
    private String _expandedUrl;
    private InetAddress _localAddress;
    protected ELogRawXmlType _logRawXmlType = ELogRawXmlType.NONE;
    protected boolean _formatOutputXmlByDefault = false;
    private AtomicInteger _requestCount = new AtomicInteger();
    private int _connectionTimeout = 0;

    public SiriCommon() {
        try {
            _log.info("Loading JAXB context.  This may take a few seconds...");
            this._jaxbContext = JAXBContext.newInstance((String)"uk.org.siri:org.onebusaway.siri:uk.org.siri.siri");
            _log.info("Loading JAXB context complete.");
        }
        catch (JAXBException ex) {
            throw new SiriSerializationException(ex);
        }
        this._identity = UUID.randomUUID().toString();
    }

    @Inject
    public void setSchedulingService(SchedulingService schedulingService) {
        this._schedulingService = schedulingService;
    }

    @Inject
    public void setHttpClientService(HttpClientService httpClientService) {
        this._httpClientService = httpClientService;
    }

    public String getIdentity() {
        return this._identity;
    }

    public void setIdentity(String identity) {
        this._identity = identity;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
        this._expandedUrl = this.replaceHostnameWildcardWithPublicHostnameInUrl(this._url);
        this.checkLocalAddress();
    }

    public String getPrivateUrl() {
        return this._privateUrl;
    }

    public void setPrivateUrl(String privateClientUrl) {
        this._privateUrl = privateClientUrl;
        this.checkLocalAddress();
    }

    public URL getInternalUrlToBind(boolean expandHostnameWildcard) {
        String clientUrl = this._url;
        if (this._privateUrl != null) {
            clientUrl = this._privateUrl;
        }
        if (expandHostnameWildcard) {
            clientUrl = this.replaceHostnameWildcardWithPublicHostnameInUrl(clientUrl);
        }
        return this.url(clientUrl);
    }

    public InetAddress getLocalAddress() {
        return this._localAddress;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this._localAddress = localAddress;
    }

    public ELogRawXmlType getLogRawXmlType() {
        return this._logRawXmlType;
    }

    public void setLogRawXmlType(ELogRawXmlType logRawXmlType) {
        this._logRawXmlType = logRawXmlType;
    }

    public boolean isFormatOutputXmlByDefault() {
        return this._formatOutputXmlByDefault;
    }

    public void setFormatOutputXmlByDefault(boolean formatOutputXmlByDefault) {
        this._formatOutputXmlByDefault = formatOutputXmlByDefault;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this._connectionTimeout = connectionTimeout;
    }

    @PostConstruct
    public void start() {
        BasicHttpParams params = new BasicHttpParams();
        if (this._localAddress != null) {
            params.setParameter("http.route.local-address", (Object)this._localAddress);
        }
        if (this._connectionTimeout != 0) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)(this._connectionTimeout * 1000));
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)(this._connectionTimeout * 1000));
        }
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)50);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        this._client = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)params);
    }

    @PreDestroy
    public void stop() {
        this._client.getConnectionManager().shutdown();
    }

    @Override
    public void getStatus(Map<String, String> status) {
        status.put("siri.common.requestCounter", Integer.toString(this._requestCount.get()));
    }

    @Override
    public void handleRawRequest(Reader reader, Writer writer) {
    }

    protected <T> T processRequestWithResponse(SiriClientRequest request, boolean asynchronous) {
        HttpResponse response;
        if (!request.isSubscribe() && request.getPollInterval() > 0) {
            AsynchronousClientRequest asyncAttempt = new AsynchronousClientRequest(request);
            this._schedulingService.schedule(asyncAttempt, request.getPollInterval(), TimeUnit.SECONDS);
        }
        this._requestCount.incrementAndGet();
        Siri payload = request.getPayload();
        payload = SiriLibrary.copy(payload);
        this.fillAllSiriStructures(payload);
        if (payload.getSubscriptionRequest() != null) {
            this.fillSubscriptionRequestStructure(request, payload.getSubscriptionRequest());
        }
        SiriVersioning versioning = SiriVersioning.getInstance();
        Object versionedPayload = versioning.getPayloadAsVersion(payload, request.getTargetVersion());
        String content = this.marshallToString(versionedPayload);
        if (this.isRawDataLogged(payload)) {
            _log.info("logging raw xml request:\n=== REQUEST BEGIN ===\n" + content + "\n=== REQUEST END ===");
        }
        if ((response = this.processRawContentRequestWithResponse(request, payload, content)) == null) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        String responseContent = null;
        Object responseData = null;
        try {
            Reader responseReader = new InputStreamReader(entity.getContent());
            _log.debug("response content length: {}", (Object)entity.getContentLength());
            if (this._logRawXmlType != ELogRawXmlType.NONE) {
                StringBuilder b = new StringBuilder();
                responseReader = this.copyReaderToStringBuilder(responseReader, b);
                responseContent = b.toString();
            }
            if (entity.getContentLength() != 0L) {
                responseData = this.unmarshall(responseReader);
                responseData = versioning.getPayloadAsVersion(responseData, versioning.getDefaultVersion());
            }
        }
        catch (Exception ex) {
            throw new SiriSerializationException(ex);
        }
        finally {
            try {
                entity.consumeContent();
            }
            catch (IOException ex) {}
        }
        if (responseData != null && responseData instanceof Siri) {
            Siri siri = (Siri)responseData;
            if (this.isRawDataLogged(siri)) {
                _log.info("logging raw xml response:\n=== RESPONSE BEGIN ===\n" + responseContent + "\n=== RESPONSE END ===");
            }
            this.handleSiriResponse(siri, asynchronous, request);
        }
        return (T)responseData;
    }

    protected void processRequestWithAsynchronousResponse(SiriClientRequest request) {
        AsynchronousClientRequest attempt = new AsynchronousClientRequest(request);
        this._schedulingService.submit(attempt);
    }

    protected void handleSiriResponse(Siri siri, boolean asynchronousResponse, SiriClientRequest siriClientRequest) {
    }

    protected void fillAllSiriStructures(Siri siri) {
        this.fillRequestStructure((RequestStructure)siri.getCapabilitiesRequest());
        this.fillRequestStructure((RequestStructure)siri.getCheckStatusRequest());
        this.fillRequestStructure((RequestStructure)siri.getFacilityRequest());
        this.fillRequestStructure((RequestStructure)siri.getInfoChannelRequest());
        this.fillRequestStructure((RequestStructure)siri.getLinesRequest());
        this.fillRequestStructure((RequestStructure)siri.getProductCategoriesRequest());
        this.fillRequestStructure((RequestStructure)siri.getServiceFeaturesRequest());
        this.fillRequestStructure((RequestStructure)siri.getStopPointsRequest());
        this.fillRequestStructure((RequestStructure)siri.getSubscriptionRequest());
        this.fillRequestStructure((RequestStructure)siri.getTerminateSubscriptionRequest());
        this.fillRequestStructure((RequestStructure)siri.getVehicleFeaturesRequest());
        this.fillServiceRequestStructure(siri.getServiceRequest());
        this.fillResponseStructure((ProducerResponseStructure)siri.getCapabilitiesResponse());
        this.fillResponseStructure(siri.getCheckStatusResponse());
        this.fillServiceDelivery(siri.getServiceDelivery());
        this.fillResponseStructure((ResponseEndpointStructure)siri.getSubscriptionResponse());
        this.fillResponseStructure((ResponseEndpointStructure)siri.getTerminateSubscriptionResponse());
    }

    protected void fillSubscriptionRequestStructure(SiriClientRequest request, SubscriptionRequest subscriptionRequest) {
        if (subscriptionRequest == null) {
            return;
        }
        int heartbeatInterval = request.getHeartbeatInterval();
        if (heartbeatInterval > 0) {
            Duration interval = _dataTypeFactory.newDuration(heartbeatInterval * 1000);
            SubscriptionContextStructure context = new SubscriptionContextStructure();
            context.setHeartbeatInterval(interval);
            subscriptionRequest.setSubscriptionContext(context);
        }
        for (ESiriModuleType moduleType : ESiriModuleType.values()) {
            List<AbstractSubscriptionStructure> subs = SiriLibrary.getSubscriptionRequestsForModule(subscriptionRequest, moduleType);
            for (AbstractSubscriptionStructure sub : subs) {
                if (sub.getSubscriberRef() == null) {
                    sub.setSubscriberRef(SiriTypeFactory.particpantRef(this._identity));
                }
                if (sub.getSubscriptionIdentifier() == null) {
                    sub.setSubscriptionIdentifier(SiriTypeFactory.randomSubscriptionId());
                }
                if (sub.getInitialTerminationTime() == null) {
                    Date initialTerminationTime = new Date(System.currentTimeMillis() + request.getInitialTerminationDuration());
                    sub.setInitialTerminationTime(initialTerminationTime);
                }
                if (!(sub instanceof VehicleMonitoringSubscriptionStructure)) continue;
                this.fillAbstractFunctionalServiceRequestStructure((AbstractFunctionalServiceRequestStructure)((VehicleMonitoringSubscriptionStructure)sub).getVehicleMonitoringRequest());
            }
        }
    }

    protected void fillRequestStructure(RequestStructure request) {
        if (request == null) {
            return;
        }
        request.setRequestorRef(SiriTypeFactory.particpantRef(this._identity));
        request.setAddress(this._expandedUrl);
        if (request.getMessageIdentifier() == null || request.getMessageIdentifier().getValue() == null) {
            MessageQualifierStructure messageIdentifier = SiriTypeFactory.randomMessageId();
            request.setMessageIdentifier(messageIdentifier);
        }
        if (request.getRequestTimestamp() == null) {
            request.setRequestTimestamp(new Date());
        }
    }

    protected void fillServiceRequestStructure(ServiceRequest request) {
        if (request == null) {
            return;
        }
        request.setRequestorRef(SiriTypeFactory.particpantRef(this._identity));
        request.setAddress(this._expandedUrl);
        if (request.getRequestTimestamp() == null) {
            request.setRequestTimestamp(new Date());
        }
        this.fillAbstractFunctionalServiceRequestStructures(request.getConnectionMonitoringRequest());
        this.fillAbstractFunctionalServiceRequestStructures(request.getConnectionTimetableRequest());
        this.fillAbstractFunctionalServiceRequestStructures(request.getEstimatedTimetableRequest());
        this.fillAbstractFunctionalServiceRequestStructures(request.getFacilityMonitoringRequest());
        this.fillAbstractFunctionalServiceRequestStructures(request.getGeneralMessageRequest());
        this.fillAbstractFunctionalServiceRequestStructures(request.getProductionTimetableRequest());
        this.fillAbstractFunctionalServiceRequestStructures(request.getSituationExchangeRequest());
        this.fillAbstractFunctionalServiceRequestStructures(request.getStopMonitoringMultipleRequest());
        this.fillAbstractFunctionalServiceRequestStructures(request.getStopMonitoringRequest());
        this.fillAbstractFunctionalServiceRequestStructures(request.getVehicleMonitoringRequest());
    }

    protected <T extends AbstractFunctionalServiceRequestStructure> void fillAbstractFunctionalServiceRequestStructures(List<T> requests) {
        for (AbstractFunctionalServiceRequestStructure request : requests) {
            this.fillAbstractFunctionalServiceRequestStructure(request);
        }
    }

    protected void fillAbstractFunctionalServiceRequestStructure(AbstractFunctionalServiceRequestStructure request) {
        this.fillAbstractRequestStructure((AbstractRequestStructure)request);
    }

    protected void fillAbstractRequestStructure(AbstractRequestStructure request) {
        if (request.getRequestTimestamp() == null) {
            request.setRequestTimestamp(new Date());
        }
    }

    protected void fillServiceDelivery(ServiceDelivery serviceDelivery) {
        this.fillResponseStructure((ProducerResponseStructure)serviceDelivery);
    }

    private void fillResponseStructure(ResponseEndpointStructure response) {
        if (response == null) {
            return;
        }
        if (response.getAddress() != null) {
            response.setAddress(this._expandedUrl);
        }
        if (response.getResponderRef() != null) {
            response.setResponderRef(SiriTypeFactory.particpantRef(this._identity));
        }
        this.fillGenericResponseStructure((ResponseStructure)response);
    }

    private void fillResponseStructure(ProducerResponseStructure response) {
        if (response == null) {
            return;
        }
        if (response.getAddress() == null) {
            response.setAddress(this._expandedUrl);
        }
        if (response.getProducerRef() == null) {
            response.setProducerRef(SiriTypeFactory.particpantRef(this._identity));
        }
        if (response.getResponseMessageIdentifier() == null) {
            response.setResponseMessageIdentifier(SiriTypeFactory.randomMessageId());
        }
        this.fillGenericResponseStructure((ResponseStructure)response);
    }

    private void fillResponseStructure(CheckStatusResponseStructure response) {
        if (response == null) {
            return;
        }
        if (response.getAddress() != null) {
            response.setAddress(this._expandedUrl);
        }
        if (response.getProducerRef() != null) {
            response.setProducerRef(SiriTypeFactory.particpantRef(this._identity));
        }
        if (response.getResponseMessageIdentifier() == null) {
            response.setResponseMessageIdentifier(SiriTypeFactory.randomMessageId());
        }
        this.fillGenericResponseStructure((ResponseStructure)response);
    }

    private void fillGenericResponseStructure(ResponseStructure response) {
        if (response == null) {
            return;
        }
        if (response.getResponseTimestamp() == null) {
            response.setResponseTimestamp(new Date());
        }
    }

    protected boolean isRawDataLogged(Siri payload) {
        switch (this._logRawXmlType) {
            case NONE: {
                return false;
            }
            case ALL: {
                return true;
            }
            case DATA: {
                return payload.getServiceDelivery() != null;
            }
            case CONTROL: {
                return payload.getServiceDelivery() == null;
            }
        }
        throw new IllegalStateException("unknown ELogRawXmlType=" + (Object)((Object)this._logRawXmlType));
    }

    public <T> T unmarshall(InputStream in) {
        try {
            Unmarshaller unmarshaller = this._jaxbContext.createUnmarshaller();
            return (T)unmarshaller.unmarshal(in);
        }
        catch (Exception ex) {
            throw new SiriSerializationException(ex);
        }
    }

    public <T> T unmarshall(Reader reader) {
        try {
            Unmarshaller unmarshaller = this._jaxbContext.createUnmarshaller();
            return (T)unmarshaller.unmarshal(reader);
        }
        catch (Exception ex) {
            throw new SiriSerializationException(ex);
        }
    }

    public void marshall(Object object, Writer writer) {
        this.marshall(object, writer, this._formatOutputXmlByDefault);
    }

    public void marshall(Object object, Writer writer, boolean formatOutput) {
        try {
            Marshaller m = this._jaxbContext.createMarshaller();
            if (formatOutput) {
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            m.marshal(object, writer);
        }
        catch (JAXBException ex) {
            throw new SiriSerializationException(ex);
        }
    }

    public String marshallToString(Object object) {
        return this.marshallToString(object, this._formatOutputXmlByDefault);
    }

    public String marshallToString(Object object, boolean formatOutput) {
        StringWriter writer = new StringWriter();
        this.marshall(object, writer, formatOutput);
        return writer.toString();
    }

    protected ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    protected HttpResponse processRawContentRequestWithResponse(SiriClientRequest request, Siri payload, String content) {
        String url = this.getUrlForRequest(request);
        if (request.getReconnectionAttempts() != 0) {
            try {
                HttpResponse response = this.sendHttpRequestWithResponse(url, content);
                if (request.getConnectionErrorCount() > 0) {
                    _log.info("successfully reconnected to " + url);
                }
                request.resetConnectionErrorCount();
                return response;
            }
            catch (SiriConnectionException ex) {
                String message = "error connecting to " + url + " (remainingConnectionAttempts=" + request.getRemainingReconnectionAttempts() + " connectionErrorCount=" + request.getConnectionErrorCount() + ")";
                if (request.getConnectionErrorCount() == 0) {
                    _log.warn(message, (Throwable)ex);
                } else {
                    _log.warn(message);
                }
                request.incrementConnectionErrorCount();
                this.cleanupFailedRequest(request, payload);
                this.reattemptRequestIfApplicable(request);
                return null;
            }
        }
        return this.sendHttpRequestWithResponse(url, content);
    }

    protected String getUrlForRequest(SiriClientRequest request) {
        Siri payload = request.getPayload();
        if (payload.getCheckStatusRequest() != null && request.getCheckStatusUrl() != null) {
            return request.getCheckStatusUrl();
        }
        if (payload.getTerminateSubscriptionRequest() != null && request.getManageSubscriptionUrl() != null) {
            return request.getManageSubscriptionUrl();
        }
        return request.getTargetUrl();
    }

    protected void sendHttpRequest(String url, String content) {
        HttpResponse response = this.sendHttpRequestWithResponse(url, content);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try {
                entity.consumeContent();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    protected HttpResponse sendHttpRequestWithResponse(String url, String content) {
        HttpPost post = new HttpPost(url);
        try {
            post.setEntity((HttpEntity)new StringEntity(content));
        }
        catch (UnsupportedEncodingException ex) {
            throw new SiriSerializationException(ex);
        }
        HttpResponse response = this._httpClientService.executeHttpMethod((HttpClient)this._client, (HttpUriRequest)post);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
                    StringBuilder b = new StringBuilder();
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        b.append(line).append('\n');
                    }
                    _log.warn("error connecting to url " + post.getURI() + " statusCode=" + statusLine.getStatusCode() + "\nrequestBody=" + content + "\nresponseBody=" + b.toString());
                    entity.consumeContent();
                }
                catch (IOException ex) {
                    _log.warn("error reading http response", (Throwable)ex);
                }
            }
            if (statusLine.getStatusCode() != 400) {
                throw new SiriConnectionException("error connecting to url " + post.getURI() + " statusCode=" + statusLine.getStatusCode());
            }
            _log.warn("statusCode=" + statusLine.getStatusCode() + " so ignoring for now");
        }
        return response;
    }

    protected void cleanupFailedRequest(SiriClientRequest request, Siri payload) {
    }

    protected void reattemptRequestIfApplicable(SiriClientRequest request) {
        if (request.getRemainingReconnectionAttempts() == 0) {
            return;
        }
        request.decrementRemainingReconnctionAttempts();
        AsynchronousClientRequest asyncAttempt = new AsynchronousClientRequest(request);
        this._schedulingService.schedule(asyncAttempt, request.getReconnectionInterval(), TimeUnit.SECONDS);
    }

    protected Reader copyReaderToStringBuilder(Reader responseReader, StringBuilder b) throws IOException {
        int rc;
        char[] buffer = new char[1024];
        while ((rc = responseReader.read(buffer)) != -1) {
            b.append(buffer, 0, rc);
        }
        responseReader.close();
        responseReader = new StringReader(b.toString());
        return responseReader;
    }

    protected URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new SiriException("bad url " + url, ex);
        }
    }

    protected String replaceHostnameWildcardWithPublicHostnameInUrl(String url) {
        try {
            URL asURL = new URL(url);
            if (asURL.getHost().equals("*")) {
                InetAddress address = Inet4Address.getLocalHost();
                String hostname = address.getHostName();
                return url.replace("*", hostname);
            }
        }
        catch (UnknownHostException e) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    protected void checkLocalAddress() {
        URL bindUrl = this.getInternalUrlToBind(false);
        if (!bindUrl.getHost().equals("*") && !bindUrl.getHost().equals("localhost")) {
            try {
                InetAddress address = InetAddress.getByName(bindUrl.getHost());
                this.setLocalAddress(address);
            }
            catch (UnknownHostException ex) {
                _log.warn("error resolving hostname: " + bindUrl.getHost(), (Throwable)ex);
            }
        }
    }

    class AsynchronousClientRequest
    implements Runnable {
        private final SiriClientRequest request;

        public AsynchronousClientRequest(SiriClientRequest request) {
            this.request = request;
        }

        SiriClientRequest getRequest() {
            return this.request;
        }

        @Override
        public void run() {
            try {
                SiriCommon.this.processRequestWithResponse(this.request, true);
            }
            catch (Throwable ex) {
                _log.error("error executing asynchronous client request", ex);
            }
        }
    }

    public static enum ELogRawXmlType {
        NONE,
        CONTROL,
        DATA,
        ALL;

    }
}

