/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.onebusaway.siri.core.ESiriModuleType;
import org.onebusaway.siri.core.SiriClientRequest;
import org.onebusaway.siri.core.SiriLibrary;
import org.onebusaway.siri.core.SiriTypeFactory;
import org.onebusaway.siri.core.exceptions.SiriException;
import org.onebusaway.siri.core.exceptions.SiriMissingArgumentException;
import org.onebusaway.siri.core.exceptions.SiriUnknownVersionException;
import org.onebusaway.siri.core.versioning.ESiriVersion;
import uk.org.siri.siri.AbstractServiceRequestStructure;
import uk.org.siri.siri.AbstractSubscriptionStructure;
import uk.org.siri.siri.CheckStatusRequestStructure;
import uk.org.siri.siri.DirectionRefStructure;
import uk.org.siri.siri.EstimatedTimetableRequestStructure;
import uk.org.siri.siri.EstimatedTimetableSubscriptionStructure;
import uk.org.siri.siri.LineRefStructure;
import uk.org.siri.siri.MessageQualifierStructure;
import uk.org.siri.siri.ProductionTimetableRequestStructure;
import uk.org.siri.siri.ProductionTimetableSubscriptionRequest;
import uk.org.siri.siri.ServiceRequest;
import uk.org.siri.siri.Siri;
import uk.org.siri.siri.SituationExchangeRequestStructure;
import uk.org.siri.siri.SituationExchangeSubscriptionStructure;
import uk.org.siri.siri.StopMonitoringRequestStructure;
import uk.org.siri.siri.StopMonitoringSubscriptionStructure;
import uk.org.siri.siri.StopTimetableRequestStructure;
import uk.org.siri.siri.StopTimetableSubscriptionStructure;
import uk.org.siri.siri.SubscriptionQualifierStructure;
import uk.org.siri.siri.SubscriptionRequest;
import uk.org.siri.siri.TerminateSubscriptionRequestStructure;
import uk.org.siri.siri.VehicleMonitoringRefStructure;
import uk.org.siri.siri.VehicleMonitoringRequestStructure;
import uk.org.siri.siri.VehicleMonitoringSubscriptionStructure;
import uk.org.siri.siri.VehicleRefStructure;

public class SiriClientRequestFactory {
    public static final String ARG_URL = "Url";
    public static final String ARG_MANAGE_SUBSCRIPTION_URL = "ManageSubscriptionUrl";
    public static final String ARG_CHECK_STATUS_URL = "CheckStatusUrl";
    public static final String ARG_VERSION = "Version";
    public static final String ARG_MODULE_TYPE = "ModuleType";
    public static final String ARG_SUBSCRIBE = "Subscribe";
    public static final String ARG_POLL_INTERVAL = "PollInterval";
    public static final String ARG_RECONNECTION_ATTEMPTS = "ReconnectionAttempts";
    public static final String ARG_RECONNECTION_INTERVAL = "ReconnectionInterval";
    public static final String ARG_HEARTBEAT_INTERVAL = "HeartbeatInterval";
    public static final String ARG_CHECK_STATUS_INTERVAL = "CheckStatusInterval";
    public static final String ARG_INITIAL_TERMINATION_TIME = "InitialTerminationTime";
    public static final String ARG_MESSAGE_IDENTIFIER = "MessageIdentifier";
    public static final String ARG_SUBSCRIPTION_IDENTIFIER = "SubscriptionIdentifier";
    public static final String ARG_MAXIMUM_VEHICLES = "MaximumVehicles";
    public static final String ARG_VEHICLE_REF = "VehicleRef";
    public static final String ARG_LINE_REF = "LineRef";
    public static final String ARG_DIRECTION_REF = "DirectionRef";
    public static final String ARG_VEHICLE_MONITORING_REF = "VehicleMonitoringRef";
    private static final DatatypeFactory _dataTypeFactory = SiriTypeFactory.createDataTypeFactory();

    public SiriClientRequest createRequest(Map<String, String> args) {
        SiriClientRequest request = new SiriClientRequest();
        this.processCommonArgs(args, request);
        if (request.isSubscribe()) {
            this.processSubscriptionRequestArgs(args, request);
        } else {
            this.processServiceRequestArgs(args, request);
        }
        return request;
    }

    public SiriClientRequest createServiceRequest(Map<String, String> args) {
        SiriClientRequest request = new SiriClientRequest();
        this.processCommonArgs(args, request);
        this.processServiceRequestArgs(args, request);
        return request;
    }

    public SiriClientRequest createSubscriptionRequest(Map<String, String> args) {
        SiriClientRequest request = new SiriClientRequest();
        this.processCommonArgs(args, request);
        this.processSubscriptionRequestArgs(args, request);
        return request;
    }

    public SiriClientRequest createCheckStatusRequest(Map<String, String> args) {
        SiriClientRequest request = new SiriClientRequest();
        this.processCommonArgs(args, request);
        CheckStatusRequestStructure checkStatusRequest = new CheckStatusRequestStructure();
        Siri payload = new Siri();
        payload.setCheckStatusRequest(checkStatusRequest);
        request.setPayload(payload);
        return request;
    }

    public SiriClientRequest createTerminateSubscriptionRequest(Map<String, String> args) {
        String subscriptionIdentifierValue;
        SiriClientRequest request = new SiriClientRequest();
        this.processCommonArgs(args, request);
        TerminateSubscriptionRequestStructure terminateRequest = new TerminateSubscriptionRequestStructure();
        Siri payload = new Siri();
        payload.setTerminateSubscriptionRequest(terminateRequest);
        request.setPayload(payload);
        String messageIdentifierValue = args.get(ARG_MESSAGE_IDENTIFIER);
        if (messageIdentifierValue != null) {
            MessageQualifierStructure messageIdentifier = new MessageQualifierStructure();
            messageIdentifier.setValue(messageIdentifierValue);
            terminateRequest.setMessageIdentifier(messageIdentifier);
        }
        if ((subscriptionIdentifierValue = args.get(ARG_SUBSCRIPTION_IDENTIFIER)) != null) {
            SubscriptionQualifierStructure value = new SubscriptionQualifierStructure();
            value.setValue(subscriptionIdentifierValue);
            terminateRequest.getSubscriptionRef().add(value);
        } else {
            terminateRequest.setAll("true");
        }
        return request;
    }

    private void processCommonArgs(Map<String, String> args, SiriClientRequest request) {
        String heartbeatIntervalValue;
        String checkStatusIntervalValue;
        String reconnectionInterval;
        String initialTerminationTime;
        String pollIntervalValue;
        String url = args.get(ARG_URL);
        if (url == null) {
            throw new SiriMissingArgumentException(ARG_URL);
        }
        request.setTargetUrl(url);
        String manageSubscriptionUrl = args.get(ARG_MANAGE_SUBSCRIPTION_URL);
        request.setManageSubscriptionUrl(manageSubscriptionUrl);
        String checkStatusUrl = args.get(ARG_CHECK_STATUS_URL);
        request.setCheckStatusUrl(checkStatusUrl);
        String versionId = args.get(ARG_VERSION);
        if (versionId != null) {
            ESiriVersion version = ESiriVersion.getVersionForVersionId(versionId);
            if (version == null) {
                throw new SiriUnknownVersionException(versionId);
            }
            request.setTargetVersion(version);
        } else {
            request.setTargetVersion(ESiriVersion.V1_3);
        }
        String subscribeValue = args.get(ARG_SUBSCRIBE);
        if (subscribeValue != null) {
            boolean subscribe = Boolean.parseBoolean(subscribeValue);
            request.setSubscribe(subscribe);
        }
        if ((pollIntervalValue = args.get(ARG_POLL_INTERVAL)) != null) {
            int pollInterval = Integer.parseInt(pollIntervalValue);
            request.setPollInterval(pollInterval);
        }
        if ((initialTerminationTime = args.get(ARG_INITIAL_TERMINATION_TIME)) != null) {
            if (initialTerminationTime.startsWith("P")) {
                Duration duration = _dataTypeFactory.newDuration(initialTerminationTime);
                request.setInitialTerminationDuration(duration.getTimeInMillis(new Date()));
            } else {
                try {
                    Date time = SiriClientRequestFactory.getIso8601StringAsTime(initialTerminationTime, TimeZone.getDefault());
                    request.setInitialTerminationDuration(time.getTime() - System.currentTimeMillis());
                }
                catch (ParseException e) {
                    throw new SiriException("error parsing initial termination time (ISO 8601)");
                }
            }
        } else {
            Calendar c = Calendar.getInstance();
            c.add(6, 1);
            request.setInitialTerminationDuration(c.getTimeInMillis() - System.currentTimeMillis());
        }
        String reconnectionAttempts = args.get(ARG_RECONNECTION_ATTEMPTS);
        if (reconnectionAttempts != null) {
            int attempts = Integer.parseInt(reconnectionAttempts);
            request.setReconnectionAttempts(attempts);
        }
        if ((reconnectionInterval = args.get(ARG_RECONNECTION_INTERVAL)) != null) {
            int interval = Integer.parseInt(reconnectionInterval);
            request.setReconnectionInterval(interval);
        }
        if ((checkStatusIntervalValue = args.get(ARG_CHECK_STATUS_INTERVAL)) != null) {
            int checkStatusInterval = Integer.parseInt(checkStatusIntervalValue);
            request.setCheckStatusInterval(checkStatusInterval);
        }
        if ((heartbeatIntervalValue = args.get(ARG_HEARTBEAT_INTERVAL)) != null) {
            int heartbeatInterval = Integer.parseInt(heartbeatIntervalValue);
            request.setHeartbeatInterval(heartbeatInterval);
        }
    }

    private void processServiceRequestArgs(Map<String, String> args, SiriClientRequest request) {
        String moduleTypeValue;
        ServiceRequest serviceRequest = new ServiceRequest();
        Siri payload = new Siri();
        payload.setServiceRequest(serviceRequest);
        request.setPayload(payload);
        String messageIdentifierValue = args.get(ARG_MESSAGE_IDENTIFIER);
        if (messageIdentifierValue != null) {
            MessageQualifierStructure messageIdentifier = new MessageQualifierStructure();
            messageIdentifier.setValue(messageIdentifierValue);
            serviceRequest.setMessageIdentifier(messageIdentifier);
        }
        if ((moduleTypeValue = args.get(ARG_MODULE_TYPE)) != null) {
            ESiriModuleType moduleType = ESiriModuleType.valueOf(moduleTypeValue.toUpperCase());
            AbstractServiceRequestStructure moduleRequest = this.createServiceRequestForModuleType(moduleType);
            this.handleModuleServiceRequestSpecificArguments(moduleType, moduleRequest, args);
            List moduleRequests = SiriLibrary.getServiceRequestsForModule(serviceRequest, moduleType);
            moduleRequests.add(moduleRequest);
        }
    }

    private AbstractServiceRequestStructure createServiceRequestForModuleType(ESiriModuleType moduleType) {
        switch (moduleType) {
            case PRODUCTION_TIMETABLE: {
                return new ProductionTimetableRequestStructure();
            }
            case ESTIMATED_TIMETABLE: {
                return new EstimatedTimetableRequestStructure();
            }
            case STOP_TIMETABLE: {
                return new StopTimetableRequestStructure();
            }
            case STOP_MONITORING: {
                return new StopMonitoringRequestStructure();
            }
            case VEHICLE_MONITORING: {
                return new VehicleMonitoringRequestStructure();
            }
            case SITUATION_EXCHANGE: {
                return new SituationExchangeRequestStructure();
            }
        }
        throw new UnsupportedOperationException();
    }

    private void processSubscriptionRequestArgs(Map<String, String> args, SiriClientRequest request) {
        String moduleTypeValue;
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest();
        Siri payload = new Siri();
        payload.setSubscriptionRequest(subscriptionRequest);
        request.setPayload(payload);
        String messageIdentifierValue = args.get(ARG_MESSAGE_IDENTIFIER);
        if (messageIdentifierValue != null) {
            MessageQualifierStructure messageIdentifier = new MessageQualifierStructure();
            messageIdentifier.setValue(messageIdentifierValue);
            subscriptionRequest.setMessageIdentifier(messageIdentifier);
        }
        if ((moduleTypeValue = args.get(ARG_MODULE_TYPE)) != null) {
            ESiriModuleType moduleType = ESiriModuleType.valueOf(moduleTypeValue.toUpperCase());
            AbstractSubscriptionStructure moduleSubscription = this.createSubscriptionForModuleType(moduleType);
            String subscriptionIdentifierValue = args.get(ARG_SUBSCRIPTION_IDENTIFIER);
            if (subscriptionIdentifierValue != null) {
                SubscriptionQualifierStructure value = new SubscriptionQualifierStructure();
                value.setValue(subscriptionIdentifierValue);
                moduleSubscription.setSubscriptionIdentifier(value);
            }
            this.handleModuleSubscriptionSpecificArguments(moduleType, moduleSubscription, args);
            List moduleSubscriptions = SiriLibrary.getSubscriptionRequestsForModule(subscriptionRequest, moduleType);
            moduleSubscriptions.add(moduleSubscription);
        }
    }

    private AbstractSubscriptionStructure createSubscriptionForModuleType(ESiriModuleType moduleType) {
        switch (moduleType) {
            case PRODUCTION_TIMETABLE: {
                return new ProductionTimetableSubscriptionRequest();
            }
            case ESTIMATED_TIMETABLE: {
                return new EstimatedTimetableSubscriptionStructure();
            }
            case STOP_TIMETABLE: {
                return new StopTimetableSubscriptionStructure();
            }
            case STOP_MONITORING: {
                return new StopMonitoringSubscriptionStructure();
            }
            case VEHICLE_MONITORING: {
                return new VehicleMonitoringSubscriptionStructure();
            }
            case SITUATION_EXCHANGE: {
                return new SituationExchangeSubscriptionStructure();
            }
        }
        throw new UnsupportedOperationException();
    }

    private void handleModuleServiceRequestSpecificArguments(ESiriModuleType moduleType, AbstractServiceRequestStructure moduleServiceRequest, Map<String, String> args) {
        switch (moduleType) {
            case VEHICLE_MONITORING: {
                this.applyArgsToVehicleMonitoringRequest((VehicleMonitoringRequestStructure)moduleServiceRequest, args);
                break;
            }
            case SITUATION_EXCHANGE: {
                this.applyArgsToSituationExchangeRequest((SituationExchangeRequestStructure)moduleServiceRequest, args);
            }
        }
    }

    private void handleModuleSubscriptionSpecificArguments(ESiriModuleType moduleType, AbstractSubscriptionStructure moduleSubscription, Map<String, String> args) {
        switch (moduleType) {
            case VEHICLE_MONITORING: {
                this.handleVehicleMonitoringSubscriptionSpecificArguments((VehicleMonitoringSubscriptionStructure)moduleSubscription, args);
                break;
            }
            case SITUATION_EXCHANGE: {
                this.handleSituationExchangeSubscriptionSpecificArguments((SituationExchangeSubscriptionStructure)moduleSubscription, args);
            }
        }
    }

    private void handleVehicleMonitoringSubscriptionSpecificArguments(VehicleMonitoringSubscriptionStructure moduleSubscription, Map<String, String> args) {
        VehicleMonitoringRequestStructure vmr = new VehicleMonitoringRequestStructure();
        moduleSubscription.setVehicleMonitoringRequest(vmr);
        this.applyArgsToVehicleMonitoringRequest(vmr, args);
    }

    private void applyArgsToVehicleMonitoringRequest(VehicleMonitoringRequestStructure vmr, Map<String, String> args) {
        String maximumVehiclesValue;
        String vehicleRefValue;
        String lineRefValue;
        String directionRefValue;
        String vehicleMonitoringRefValue = args.get(ARG_VEHICLE_MONITORING_REF);
        if (vehicleMonitoringRefValue != null) {
            VehicleMonitoringRefStructure vehicleMonitoringRef = new VehicleMonitoringRefStructure();
            vehicleMonitoringRef.setValue(vehicleMonitoringRefValue);
            vmr.setVehicleMonitoringRef(vehicleMonitoringRef);
        }
        if ((directionRefValue = args.get(ARG_DIRECTION_REF)) != null) {
            DirectionRefStructure directionRef = new DirectionRefStructure();
            directionRef.setValue(directionRefValue);
            vmr.setDirectionRef(directionRef);
        }
        if ((lineRefValue = args.get(ARG_LINE_REF)) != null) {
            LineRefStructure lineRef = new LineRefStructure();
            lineRef.setValue(lineRefValue);
            vmr.setLineRef(lineRef);
        }
        if ((vehicleRefValue = args.get(ARG_VEHICLE_REF)) != null) {
            VehicleRefStructure vehicleRef = new VehicleRefStructure();
            vehicleRef.setValue(vehicleRefValue);
            vmr.setVehicleRef(vehicleRef);
        }
        if ((maximumVehiclesValue = args.get(ARG_MAXIMUM_VEHICLES)) != null) {
            vmr.setMaximumVehicles(new BigInteger(maximumVehiclesValue));
        }
    }

    private void handleSituationExchangeSubscriptionSpecificArguments(SituationExchangeSubscriptionStructure moduleSubscription, Map<String, String> args) {
        SituationExchangeRequestStructure request = new SituationExchangeRequestStructure();
        moduleSubscription.setSituationExchangeRequest(request);
        this.applyArgsToSituationExchangeRequest(request, args);
    }

    private void applyArgsToSituationExchangeRequest(SituationExchangeRequestStructure request, Map<String, String> args) {
    }

    private static Date getIso8601StringAsTime(String value, TimeZone timeZone) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        format.setTimeZone(timeZone);
        int n = value.length();
        if (n > 6) {
            char c1 = value.charAt(n - 6);
            char c2 = value.charAt(n - 3);
            if ((c1 == '-' || c1 == '+') && c2 == ':') {
                value = value.substring(0, n - 3) + value.substring(n - 2);
            }
        }
        return format.parse(value);
    }
}

