/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core;

import org.onebusaway.siri.core.versioning.ESiriVersion;
import uk.org.siri.siri.Siri;

public class SiriClientRequest {
    private String targetUrl;
    private String manageSubscriptionUrl;
    private String checkStatusUrl;
    private ESiriVersion targetVersion;
    private boolean subscribe = true;
    private int pollInterval = 0;
    private int reconnectionAttempts = 0;
    private int reconnectionInterval = 60;
    private int remainingReconnectionAttempts = 0;
    private int connectionErrorCount = 0;
    private int checkStatusInterval = 0;
    private int heartbeatInterval = 0;
    private long initialTerminationDuration;
    private Object channelContext;
    private Siri payload;

    public SiriClientRequest() {
    }

    public SiriClientRequest(SiriClientRequest request) {
        this.targetUrl = request.targetUrl;
        this.manageSubscriptionUrl = request.manageSubscriptionUrl;
        this.checkStatusUrl = request.checkStatusUrl;
        this.targetVersion = request.targetVersion;
        this.subscribe = request.subscribe;
        this.pollInterval = request.pollInterval;
        this.reconnectionAttempts = request.reconnectionAttempts;
        this.reconnectionInterval = request.reconnectionInterval;
        this.checkStatusInterval = request.checkStatusInterval;
        this.heartbeatInterval = request.heartbeatInterval;
        this.initialTerminationDuration = request.initialTerminationDuration;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public String getManageSubscriptionUrl() {
        return this.manageSubscriptionUrl;
    }

    public void setManageSubscriptionUrl(String manageSubscriptionUrl) {
        this.manageSubscriptionUrl = manageSubscriptionUrl;
    }

    public String getCheckStatusUrl() {
        return this.checkStatusUrl;
    }

    public void setCheckStatusUrl(String checkStatusUrl) {
        this.checkStatusUrl = checkStatusUrl;
    }

    public ESiriVersion getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(ESiriVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    public boolean isSubscribe() {
        return this.subscribe;
    }

    public void setSubscribe(boolean subscribe) {
        this.subscribe = subscribe;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    public int getReconnectionAttempts() {
        return this.reconnectionAttempts;
    }

    public void setReconnectionAttempts(int reconnectionAttempts) {
        this.reconnectionAttempts = reconnectionAttempts;
    }

    public int getReconnectionInterval() {
        return this.reconnectionInterval;
    }

    public void setReconnectionInterval(int reconnectionInterval) {
        this.reconnectionInterval = reconnectionInterval;
    }

    public int getRemainingReconnectionAttempts() {
        return this.remainingReconnectionAttempts;
    }

    public void decrementRemainingReconnctionAttempts() {
        if (this.remainingReconnectionAttempts > 0) {
            --this.remainingReconnectionAttempts;
        }
    }

    public int getConnectionErrorCount() {
        return this.connectionErrorCount;
    }

    public void incrementConnectionErrorCount() {
        ++this.connectionErrorCount;
    }

    public void resetConnectionErrorCount() {
        this.connectionErrorCount = 0;
    }

    public void resetConnectionStatistics() {
        this.connectionErrorCount = 0;
        this.remainingReconnectionAttempts = this.reconnectionAttempts;
    }

    public int getCheckStatusInterval() {
        return this.checkStatusInterval;
    }

    public void setCheckStatusInterval(int checkStatusInterval) {
        this.checkStatusInterval = checkStatusInterval;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(int heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public long getInitialTerminationDuration() {
        return this.initialTerminationDuration;
    }

    public void setInitialTerminationDuration(long initialTerminationDuration) {
        this.initialTerminationDuration = initialTerminationDuration;
    }

    public Object getChannelContext() {
        return this.channelContext;
    }

    public void setChannelContext(Object channelContext) {
        this.channelContext = channelContext;
    }

    public Siri getPayload() {
        return this.payload;
    }

    public void setPayload(Siri payload) {
        this.payload = payload;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.targetUrl != null) {
            b.append("targetUrl=").append(this.targetUrl);
        }
        return b.toString();
    }
}

