/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.siri.core;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.onebusaway.siri.core.ESiriModuleType;
import org.onebusaway.siri.core.SiriChannelInfo;
import org.onebusaway.siri.core.SiriClientRequest;
import org.onebusaway.siri.core.SiriCommon;
import org.onebusaway.siri.core.SiriLibrary;
import org.onebusaway.siri.core.exceptions.SiriException;
import org.onebusaway.siri.core.handlers.SiriClientHandler;
import org.onebusaway.siri.core.handlers.SiriRawHandler;
import org.onebusaway.siri.core.handlers.SiriServiceDeliveryHandler;
import org.onebusaway.siri.core.services.ExponentialWeightedAverageForTimeWindow;
import org.onebusaway.siri.core.subscriptions.client.SiriClientSubscriptionManager;
import org.onebusaway.siri.core.versioning.SiriVersioning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri.AbstractServiceDeliveryStructure;
import uk.org.siri.siri.ServiceDelivery;
import uk.org.siri.siri.Siri;
import uk.org.siri.siri.SubscriptionRequest;

@Singleton
public class SiriClient
extends SiriCommon
implements SiriClientHandler,
SiriRawHandler {
    private static Logger _log = LoggerFactory.getLogger(SiriClient.class);
    private List<SiriServiceDeliveryHandler> _serviceDeliveryHandlers = new ArrayList<SiriServiceDeliveryHandler>();
    private SiriClientSubscriptionManager _subscriptionManager;
    private boolean _includeDeliveriesToUnknownSubscription = true;
    private boolean _waitForTerminateSubscriptionResponseOnExit = true;
    private AtomicInteger _serviceDeliveryCounter = new AtomicInteger();
    private ExponentialWeightedAverageForTimeWindow _serviceDeliveryDelay = new ExponentialWeightedAverageForTimeWindow(300000L);

    public SiriClient() {
        this.setUrl("http://*:8080/client.xml");
    }

    @Inject
    public void setSubscriptionManager(SiriClientSubscriptionManager subscriptionManager) {
        this._subscriptionManager = subscriptionManager;
    }

    public void addServiceDeliveryHandler(SiriServiceDeliveryHandler handler) {
        this._serviceDeliveryHandlers.add(handler);
    }

    public void removeServiceDeliveryHandler(SiriServiceDeliveryHandler handler) {
        this._serviceDeliveryHandlers.remove(handler);
    }

    public void setIncludeDeliveriesToUnknownSubscription(boolean includeDeliveriesToUnknownSubscription) {
        this._includeDeliveriesToUnknownSubscription = includeDeliveriesToUnknownSubscription;
    }

    @Override
    public void stop() {
        super.stop();
        this._subscriptionManager.terminateAllSubscriptions(this._waitForTerminateSubscriptionResponseOnExit);
    }

    @Override
    public Siri handleRequestWithResponse(SiriClientRequest request) {
        this.checkRequest(request);
        request.resetConnectionStatistics();
        return (Siri)this.processRequestWithResponse(request, false);
    }

    @Override
    public void handleRequest(SiriClientRequest request) {
        this.checkRequest(request);
        request.resetConnectionStatistics();
        this.processRequestWithAsynchronousResponse(request);
    }

    @Override
    public void handleRequestReconnectIfApplicable(SiriClientRequest request) {
        this.checkRequest(request);
        this.reattemptRequestIfApplicable(request);
    }

    @Override
    public void handleRawRequest(Reader reader, Writer writer) {
        String responseContent = null;
        if (this._logRawXmlType != SiriCommon.ELogRawXmlType.NONE) {
            try {
                StringBuilder b = new StringBuilder();
                reader = this.copyReaderToStringBuilder(reader, b);
                responseContent = b.toString();
            }
            catch (IOException ex) {
                throw new SiriException("error reading incoming request", ex);
            }
        }
        Object data = this.unmarshall(reader);
        SiriVersioning instance = SiriVersioning.getInstance();
        data = instance.getPayloadAsVersion(data, instance.getDefaultVersion());
        if (data instanceof Siri) {
            Siri siri = (Siri)data;
            if (this.isRawDataLogged(siri)) {
                _log.info("logging raw xml response:\n=== PUBLISHED BEGIN ===\n" + responseContent + "\n=== PUBLISHED END ===");
            }
            this.handleSiriResponse(siri, true, null);
        }
    }

    protected void checkRequest(SiriClientRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        if (request.getTargetUrl() == null) {
            throw new IllegalArgumentException("targetUrl is null for request");
        }
        if (request.getTargetVersion() == null) {
            throw new IllegalArgumentException("targetVersion is null for request");
        }
        if (request.getPayload() == null) {
            throw new IllegalArgumentException("payload is null for request");
        }
    }

    @Override
    protected void fillSubscriptionRequestStructure(SiriClientRequest request, SubscriptionRequest subscriptionRequest) {
        super.fillSubscriptionRequestStructure(request, subscriptionRequest);
        this._subscriptionManager.registerPendingSubscription(request, subscriptionRequest);
    }

    @Override
    protected void cleanupFailedRequest(SiriClientRequest request, Siri failedPayload) {
        super.cleanupFailedRequest(request, failedPayload);
        if (failedPayload.getSubscriptionRequest() != null) {
            this._subscriptionManager.clearPendingSubscription(request, failedPayload.getSubscriptionRequest());
        }
    }

    @Override
    protected void handleSiriResponse(Siri siri, boolean asynchronousResponse, SiriClientRequest siriClientRequest) {
        super.handleSiriResponse(siri, asynchronousResponse, siriClientRequest);
        if (siri.getSubscriptionResponse() != null) {
            this._subscriptionManager.handleSubscriptionResponse(siri.getSubscriptionResponse());
        }
        if (siri.getTerminateSubscriptionResponse() != null) {
            this._subscriptionManager.handleTerminateSubscriptionResponse(siri.getTerminateSubscriptionResponse());
        }
        if (siri.getCheckStatusResponse() != null) {
            this._subscriptionManager.handleCheckStatusNotification(siri.getCheckStatusResponse());
        }
        if (siri.getHeartbeatNotification() != null) {
            this._subscriptionManager.handleHeartbeatNotification(siri.getHeartbeatNotification());
        }
        if (asynchronousResponse && siri.getServiceDelivery() != null) {
            this.handleServiceDelivery(siri.getServiceDelivery(), siriClientRequest);
        }
    }

    @Override
    public void getStatus(Map<String, String> status) {
        super.getStatus(status);
        status.put("siri.client.serviceDeliveryCounter", Integer.toString(this._serviceDeliveryCounter.get()));
        status.put("siri.client.serviceDeliveryDelay", Long.toString((long)this._serviceDeliveryDelay.getAverage()));
    }

    private void handleServiceDelivery(ServiceDelivery serviceDelivery, SiriClientRequest siriClientRequest) {
        this._serviceDeliveryCounter.incrementAndGet();
        Date timestamp = serviceDelivery.getResponseTimestamp();
        if (timestamp != null) {
            long now = System.currentTimeMillis();
            this._serviceDeliveryDelay.addValueAtTime(now - timestamp.getTime(), now);
        }
        this.checkServiceDeliveryForUnknownSubscriptions(serviceDelivery);
        SiriChannelInfo channelInfo = this._subscriptionManager.getChannelInfoForServiceDelivery(serviceDelivery);
        if (siriClientRequest != null && !channelInfo.getSiriClientRequests().contains(siriClientRequest)) {
            channelInfo.getSiriClientRequests().add(siriClientRequest);
        }
        for (SiriServiceDeliveryHandler handler : this._serviceDeliveryHandlers) {
            handler.handleServiceDelivery(channelInfo, serviceDelivery);
        }
    }

    private void checkServiceDeliveryForUnknownSubscriptions(ServiceDelivery serviceDelivery) {
        if (this._includeDeliveriesToUnknownSubscription) {
            return;
        }
        for (ESiriModuleType moduleType : ESiriModuleType.values()) {
            List moduleDeliveries = SiriLibrary.getServiceDeliveriesForModule(serviceDelivery, moduleType);
            Iterator it = moduleDeliveries.iterator();
            while (it.hasNext()) {
                AbstractServiceDeliveryStructure moduleDelivery = (AbstractServiceDeliveryStructure)it.next();
                if (this._subscriptionManager.isSubscriptionActiveForModuleDelivery(moduleDelivery)) continue;
                _log.warn("module service delivery of type + " + (Object)((Object)moduleType) + " for unknown subcription: TODO");
                it.remove();
            }
        }
    }
}

