/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.spring.jmx;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.naming.MetadataNamingStrategy;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.web.context.ServletContextAware;

public class ServletContextAwareMetadataNamingStrategy
extends MetadataNamingStrategy
implements ServletContextAware {
    private String _servletName;

    public ServletContextAwareMetadataNamingStrategy(JmxAttributeSource annotationSource) {
        super(annotationSource);
    }

    public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
        ObjectName objName = super.getObjectName(managedBean, beanKey);
        if (this._servletName != null) {
            Object canonicalName = objName.getCanonicalName();
            canonicalName = (String)canonicalName + ",application=" + ObjectName.quote(this._servletName);
            objName = ObjectNameManager.getInstance((String)canonicalName);
        }
        return objName;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletName = this.getContextPath(servletContext);
    }

    private String getContextPath(ServletContext context) {
        String contextPath = "";
        try {
            String path = context.getResource("/").getPath();
            contextPath = path.substring(0, path.lastIndexOf("/"));
            contextPath = contextPath.substring(contextPath.lastIndexOf("/"));
            if (contextPath.equals("/localhost")) {
                contextPath = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contextPath;
    }
}

