/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.spring.ehcache;

import java.io.IOException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import net.sf.ehcache.constructs.blocking.UpdatingSelfPopulatingCache;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class EhCacheFactoryBean
implements FactoryBean<Ehcache>,
BeanNameAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;
    private String cacheName;
    private int maxElementsInMemory = 10000;
    private int maxElementsOnDisk = 10000000;
    private MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.LRU;
    private boolean overflowToDisk = true;
    private boolean eternal = false;
    private int timeToLive = 300;
    private int timeToIdle = 120;
    private boolean diskPersistent = false;
    private int diskExpiryThreadIntervalSeconds = 300;
    private boolean blocking = false;
    private boolean terracottaClustered = false;
    private CacheEntryFactory cacheEntryFactory;
    private String beanName;
    private Ehcache cache;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public void setMaxElementsOnDisk(int maxElementsOnDisk) {
        this.maxElementsOnDisk = maxElementsOnDisk;
    }

    public void setMemoryStoreEvictionPolicy(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        Assert.notNull((Object)memoryStoreEvictionPolicy, (String)"memoryStoreEvictionPolicy must not be null");
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public void setOverflowToDisk(boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
    }

    public void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTimeToIdle(int timeToIdle) {
        this.timeToIdle = timeToIdle;
    }

    public void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }

    public void setDiskExpiryThreadIntervalSeconds(int diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setTerracottaClustered(boolean terracottaClustered) {
        this.terracottaClustered = terracottaClustered;
    }

    public void setCacheEntryFactory(CacheEntryFactory cacheEntryFactory) {
        this.cacheEntryFactory = cacheEntryFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void afterPropertiesSet() throws CacheException, IOException {
        if (this.cacheManager == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using default EHCache CacheManager for cache region '" + this.cacheName + "'"));
            }
            this.cacheManager = CacheManager.getInstance();
        }
        if (this.cacheName == null) {
            this.cacheName = this.beanName;
        }
        Cache rawCache = null;
        if (this.cacheManager.cacheExists(this.cacheName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using existing EHCache cache region '" + this.cacheName + "'"));
            }
            rawCache = this.cacheManager.getEhcache(this.cacheName);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating new EHCache cache region '" + this.cacheName + "'"));
            }
            rawCache = this.createCache();
            this.cacheManager.addCache((Ehcache)rawCache);
        }
        Ehcache decoratedCache = this.decorateCache((Ehcache)rawCache);
        if (decoratedCache != rawCache) {
            this.cacheManager.replaceCacheWithDecoratedCache((Ehcache)rawCache, decoratedCache);
        }
        this.cache = decoratedCache;
    }

    private Cache createCache() {
        CacheConfiguration config = new CacheConfiguration(this.cacheName, this.maxElementsInMemory);
        config.setMemoryStoreEvictionPolicyFromObject(this.memoryStoreEvictionPolicy);
        config.setEternal(this.eternal);
        config.setTimeToLiveSeconds((long)this.timeToLive);
        config.setTimeToIdleSeconds((long)this.timeToIdle);
        PersistenceConfiguration pc = new PersistenceConfiguration();
        if (this.diskPersistent) {
            pc.strategy(PersistenceConfiguration.Strategy.LOCALRESTARTABLE);
        } else if (this.overflowToDisk) {
            pc.strategy(PersistenceConfiguration.Strategy.LOCALTEMPSWAP);
        } else {
            pc.strategy(PersistenceConfiguration.Strategy.NONE);
        }
        config.setDiskExpiryThreadIntervalSeconds((long)this.diskExpiryThreadIntervalSeconds);
        config.setMaxElementsOnDisk(this.maxElementsOnDisk);
        if (this.terracottaClustered) {
            TerracottaConfiguration tcConfig = new TerracottaConfiguration();
            tcConfig.setClustered(true);
            config.terracotta(tcConfig);
        }
        return new Cache(config);
    }

    protected Ehcache decorateCache(Ehcache cache) {
        if (this.cacheEntryFactory != null) {
            if (this.cacheEntryFactory instanceof UpdatingCacheEntryFactory) {
                return new UpdatingSelfPopulatingCache(cache, (UpdatingCacheEntryFactory)this.cacheEntryFactory);
            }
            return new SelfPopulatingCache(cache, this.cacheEntryFactory);
        }
        if (this.blocking) {
            return new BlockingCache(cache);
        }
        return cache;
    }

    public Ehcache getObject() {
        return this.cache;
    }

    public Class<?> getObjectType() {
        return this.cache != null ? this.cache.getClass() : Ehcache.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

