/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.spring;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.core.Ordered;

public class PropertiesBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private int _order;
    private Set<String> _targets = new HashSet<String>();
    private Properties _properties;

    public void setTarget(String target) {
        this.setTargets(Arrays.asList(target));
    }

    public void setTargets(List<String> targets) {
        this._targets.clear();
        this._targets.addAll(targets);
    }

    public void setProperties(Properties properties) {
        this._properties = properties;
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public int getOrder() {
        return this._order;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object obj, String beanName) throws BeansException {
        if (this._properties != null && this._targets.contains(beanName)) {
            if (obj instanceof Properties) {
                Properties properties = (Properties)obj;
                properties.putAll((Map<?, ?>)this._properties);
            } else if (obj instanceof PropertiesFactoryBean) {
                PropertiesFactoryBean factory = (PropertiesFactoryBean)obj;
                System.out.println(factory);
            }
        }
        return obj;
    }
}

