/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.spring;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.container.model.HasListeners;

public class ListenerConnector<T> {
    private HasListeners<T> _source;
    private T _listener;
    private List<HasListeners<T>> _sources;

    public void setSource(HasListeners<T> source) {
        this._source = source;
    }

    public void setSources(List<HasListeners<T>> sources) {
        this._sources = sources;
    }

    public void setListener(T listener) {
        this._listener = listener;
    }

    @PostConstruct
    public void start() {
        this.addListener(this._source, this._listener);
        if (this._sources != null) {
            for (HasListeners<T> source : this._sources) {
                this.addListener(source, this._listener);
            }
        }
    }

    @PreDestroy
    public void stop() {
        this.removeListener(this._source, this._listener);
        if (this._sources != null) {
            for (HasListeners<T> source : this._sources) {
                this.removeListener(source, this._listener);
            }
        }
    }

    private void addListener(HasListeners<T> source, T listener) {
        if (source != null && listener != null) {
            source.addListener(listener);
        }
    }

    private void removeListener(HasListeners<T> source, T listener) {
        if (source != null && listener != null) {
            source.removeListener(listener);
        }
    }
}

