/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.rotation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.onebusaway.container.rotation.RotationStrategy;

public class TimeRotationStrategy
implements RotationStrategy {
    private DateFormat _timeFormat;
    private String _lastFormat;

    public TimeRotationStrategy(String format) {
        this._timeFormat = new SimpleDateFormat(format);
    }

    @Override
    public Writer getFirstWriter() throws IOException {
        this._lastFormat = this._timeFormat.format(new Date());
        File path = new File(this._lastFormat);
        File parent = path.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        return new FileWriter(new File(this._lastFormat), true);
    }

    @Override
    public Writer getNextWriter(Writer writer, int charactersWritten) throws IOException {
        String format = this._timeFormat.format(new Date());
        if (this._lastFormat.equals(format)) {
            return writer;
        }
        this._lastFormat = format;
        return new FileWriter(format, true);
    }
}

