/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.refresh;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.container.refresh.RefreshService;
import org.onebusaway.container.refresh.Refreshable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

class RefreshServiceImpl
implements RefreshService,
BeanPostProcessor {
    private static Logger _log = LoggerFactory.getLogger(RefreshServiceImpl.class);
    private Map<String, List<ObjectMethodPair>> _refreshMethodsByName = new HashMap<String, List<ObjectMethodPair>>();

    RefreshServiceImpl() {
    }

    @Override
    public void refresh(String name) {
        List<ObjectMethodPair> pairs = this._refreshMethodsByName.get(name);
        if (pairs != null) {
            for (ObjectMethodPair pair : pairs) {
                this.invokePair(pair);
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.visitClass(bean, bean.getClass());
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.visitClass(bean, bean.getClass());
        return bean;
    }

    private void visitClass(Object target, Class<? extends Object> clazz) {
        Class<? extends Object> superclass = clazz.getSuperclass();
        if (superclass != null) {
            this.visitClass(target, superclass);
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.visitClass(target, clazz2);
        }
        for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
            Refreshable r = ((Method)genericDeclaration).getAnnotation(Refreshable.class);
            if (r == null) continue;
            Class<?>[] params = ((Method)genericDeclaration).getParameterTypes();
            if (params.length > 0) {
                _log.warn("@Refreshable methods cannot have arguments: " + (Method)genericDeclaration);
                continue;
            }
            for (String resourceName : r.dependsOn()) {
                List<ObjectMethodPair> pairs = this._refreshMethodsByName.get(resourceName);
                if (pairs == null) {
                    pairs = new ArrayList<ObjectMethodPair>();
                    this._refreshMethodsByName.put(resourceName, pairs);
                }
                if (this.contains(pairs, target, (Method)genericDeclaration)) continue;
                pairs.add(new ObjectMethodPair(target, (Method)genericDeclaration));
            }
        }
    }

    private boolean contains(List<ObjectMethodPair> pairs, Object target, Method method) {
        for (ObjectMethodPair omp : pairs) {
            if (!omp.getObject().equals(target) || !omp.getMethod().equals(method)) continue;
            return true;
        }
        return false;
    }

    private void invokePair(ObjectMethodPair pair) {
        Object object = pair.getObject();
        Method method = pair.getMethod();
        try {
            ReflectionUtils.makeAccessible((Method)method);
            method.invoke(object, new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("error invoking refresh method=" + method + " on target object=" + object, ex);
        }
    }

    private static class ObjectMethodPair {
        private final Object object;
        private final Method method;

        public ObjectMethodPair(Object object, Method method) {
            this.object = object;
            this.method = method;
        }

        public Object getObject() {
            return this.object;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

