/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.cache;

import java.io.Serializable;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.onebusaway.container.cache.CacheKeyInfo;
import org.onebusaway.container.cache.CacheableMethodKeyFactory;
import org.onebusaway.container.cache.CacheableObjectKeyFactory;

public class DefaultCacheableKeyFactory
implements CacheableMethodKeyFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private CacheableObjectKeyFactory[] _keyFactories;

    public DefaultCacheableKeyFactory(CacheableObjectKeyFactory[] keyFactories) {
        this._keyFactories = keyFactories;
    }

    public int getNumberOfObjectKeyFactories() {
        return this._keyFactories.length;
    }

    public CacheableObjectKeyFactory getObjectKeyFactory(int i) {
        return this._keyFactories[i];
    }

    @Override
    public CacheKeyInfo createKey(ProceedingJoinPoint point) {
        Object[] args = point.getArgs();
        if (args.length != this._keyFactories.length) {
            throw new IllegalArgumentException();
        }
        if (args.length == 1) {
            return this._keyFactories[0].createKey(args[0]);
        }
        KeyImpl keys = new KeyImpl(args.length);
        boolean refreshCache = false;
        for (int i = 0; i < args.length; ++i) {
            CacheKeyInfo keyInfo = this._keyFactories[i].createKey(args[i]);
            keys.set(i, keyInfo.getKey());
            refreshCache |= keyInfo.isCacheRefreshIndicated();
        }
        return new CacheKeyInfo(keys, refreshCache);
    }

    static class KeyImpl
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Serializable[] _keys;

        public KeyImpl(int entries) {
            this._keys = new Serializable[entries];
        }

        public KeyImpl(Serializable[] keys) {
            this._keys = keys;
        }

        public void set(int index, Serializable key) {
            this._keys[index] = key;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof KeyImpl)) {
                return false;
            }
            KeyImpl other = (KeyImpl)obj;
            return Arrays.equals(this._keys, other._keys);
        }

        public int hashCode() {
            return Arrays.hashCode(this._keys);
        }

        public String toString() {
            return Arrays.toString(this._keys);
        }
    }
}

