/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.cache;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.ObjectExistsException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.onebusaway.container.cache.CacheKeyInfo;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.container.cache.CacheableMethodKeyFactory;
import org.onebusaway.container.cache.CacheableMethodKeyFactoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheableMethodManager {
    private static Logger _log = LoggerFactory.getLogger(CacheableMethodManager.class);
    private ConcurrentHashMap<String, CacheEntry> _entries = new ConcurrentHashMap();
    private CacheManager _cacheManager;
    protected CacheableMethodKeyFactoryManager _cacheableMethodKeyFactoryManager;
    private String _cacheNamePrefix;

    public void setCacheManager(CacheManager cacheManager) {
        this._cacheManager = cacheManager;
    }

    public void setCacheableMethodKeyFactoryManager(CacheableMethodKeyFactoryManager cacheableMethodKeyFactoryManager) {
        this._cacheableMethodKeyFactoryManager = cacheableMethodKeyFactoryManager;
    }

    public void setCacheNamePrefix(String cacheNamePrefix) {
        this._cacheNamePrefix = cacheNamePrefix;
    }

    public Object evaluate(ProceedingJoinPoint pjp) throws Throwable {
        CacheKeyInfo keyInfo;
        Serializable key;
        CacheEntry entry = this.getCache(pjp);
        CacheableMethodKeyFactory keyFactory = entry.getKeyFactory();
        Cache cache = entry.getCache();
        Element element = cache.get(key = (keyInfo = keyFactory.createKey(pjp)).getKey());
        if (element == null || keyInfo.isCacheRefreshIndicated()) {
            Object retVal = pjp.proceed();
            element = new Element((Object)key, retVal);
            cache.put(element);
        }
        if (entry.isValueSerializable()) {
            return element.getValue();
        }
        return element.getObjectValue();
    }

    protected CacheableMethodKeyFactory getKeyFactory(ProceedingJoinPoint pjp, Method method) {
        return this._cacheableMethodKeyFactoryManager.getCacheableMethodKeyFactoryForJoinPoint(pjp, method);
    }

    protected String getCacheName(ProceedingJoinPoint pjp) {
        Signature sig = pjp.getSignature();
        StringBuilder b = new StringBuilder();
        if (this._cacheNamePrefix != null) {
            b.append(this._cacheNamePrefix).append("-");
        }
        b.append(sig.getDeclaringTypeName()).append('.').append(sig.getName());
        return b.toString();
    }

    protected Cache createCache(ProceedingJoinPoint pjp, String name) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry getCache(ProceedingJoinPoint pjp) {
        String name = this.getCacheName(pjp);
        CacheEntry entry = this._entries.get(name);
        if (entry == null) {
            Method method = this._cacheableMethodKeyFactoryManager.getMatchingMethodForJoinPoint(pjp);
            CacheableMethodKeyFactory keyFactory = this.getKeyFactory(pjp, method);
            boolean valueSerializable = this.isValueSerializable(pjp, method);
            Cache cache = this._cacheManager.getCache(name);
            if (cache == null) {
                cache = this.createCache(pjp, name);
                if (cache == null) {
                    if (!this._cacheManager.cacheExists(name)) {
                        try {
                            this._cacheManager.addCache(name);
                        }
                        catch (ObjectExistsException oee) {
                            _log.error("Cache already exists: " + name);
                        }
                    }
                    cache = this._cacheManager.getCache(name);
                } else {
                    try {
                        this._cacheManager.addCache(cache);
                    }
                    catch (ObjectExistsException oee) {
                        _log.error("Cache already exists: " + name);
                    }
                }
            }
            ConcurrentHashMap<String, CacheEntry> concurrentHashMap = this._entries;
            synchronized (concurrentHashMap) {
                entry = new CacheEntry(keyFactory, valueSerializable, cache);
                if (this._entries.containsKey(name)) {
                    _log.warn("concurrent attempt to create cache = " + name);
                } else {
                    this._entries.put(name, entry);
                }
            }
        }
        return this._entries.get(name);
    }

    private boolean isValueSerializable(ProceedingJoinPoint pjp, Method method) {
        Cacheable c = method.getAnnotation(Cacheable.class);
        if (c == null) {
            return true;
        }
        return c.isValueSerializable();
    }

    private static class CacheEntry {
        private CacheableMethodKeyFactory _keyFactory;
        private boolean _valueSerializable;
        private Cache _cache;

        public CacheEntry(CacheableMethodKeyFactory keyFactory, boolean valueSerializable, Cache cache) {
            this._keyFactory = keyFactory;
            this._valueSerializable = valueSerializable;
            this._cache = cache;
        }

        public CacheableMethodKeyFactory getKeyFactory() {
            return this._keyFactory;
        }

        public boolean isValueSerializable() {
            return this._valueSerializable;
        }

        public Cache getCache() {
            return this._cache;
        }
    }
}

