/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ContainerLibrary {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String FILE_PREFIX = "file:";

    public static ConfigurableApplicationContext createContext(String ... paths) {
        ArrayList<String> list = new ArrayList<String>();
        for (String path : paths) {
            list.add(path);
        }
        return ContainerLibrary.createContext(list);
    }

    public static ConfigurableApplicationContext createContext(Iterable<String> paths) {
        return ContainerLibrary.createContext(paths, new HashMap<String, BeanDefinition>());
    }

    public static ConfigurableApplicationContext createContext(Iterable<String> paths, Map<String, BeanDefinition> additionalBeans) {
        GenericApplicationContext ctx = new GenericApplicationContext();
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        for (String string : paths) {
            if (string.startsWith(CLASSPATH_PREFIX)) {
                String string2 = string.substring(CLASSPATH_PREFIX.length());
                xmlReader.loadBeanDefinitions((Resource)new ClassPathResource(string2));
                continue;
            }
            if (string.startsWith(FILE_PREFIX)) {
                String string3 = string.substring(FILE_PREFIX.length());
                xmlReader.loadBeanDefinitions((Resource)new FileSystemResource(string3));
                continue;
            }
            xmlReader.loadBeanDefinitions((Resource)new ClassPathResource(string));
        }
        for (Map.Entry entry : additionalBeans.entrySet()) {
            ctx.registerBeanDefinition((String)entry.getKey(), (BeanDefinition)entry.getValue());
        }
        ctx.refresh();
        ctx.registerShutdownHook();
        return ctx;
    }

    public static <T> T getBeanOfType(ApplicationContext context, Class<T> beanType) {
        Map beans = context.getBeansOfType(beanType);
        if (beans.size() == 0) {
            throw new IllegalStateException("no beans of type " + beanType.getName());
        }
        if (beans.size() > 1) {
            throw new IllegalStateException("multiple beans of type " + beanType.getName());
        }
        return (T)beans.values().iterator().next();
    }
}

