/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.utilities;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.onebusaway.container.ContainerLibrary;
import org.onebusaway.transit_data_federation.bundle.model.GtfsBundle;
import org.onebusaway.transit_data_federation.bundle.model.GtfsBundles;
import org.springframework.context.ConfigurableApplicationContext;

public class UtilityLibrary {
    public static List<GtfsBundle> getGtfsBundlesForArguments(List<String> args) {
        ArrayList<GtfsBundle> allBundles = new ArrayList<GtfsBundle>();
        ArrayList<Object> contextPaths = new ArrayList<Object>();
        int defaultAgencyIdOffset = 99990;
        for (String arg : args) {
            if (arg.endsWith(".xml")) {
                contextPaths.add("file:" + arg);
                continue;
            }
            String defaultAgencyId = null;
            int index = arg.indexOf(58);
            if (index != -1) {
                defaultAgencyId = arg.substring(index + 1);
                arg = arg.substring(0, index);
            } else {
                defaultAgencyId = Integer.toString(defaultAgencyIdOffset++);
            }
            GtfsBundle bundle = new GtfsBundle();
            bundle.setPath(new File(arg));
            bundle.setDefaultAgencyId(defaultAgencyId);
            allBundles.add(bundle);
        }
        if (!contextPaths.isEmpty()) {
            contextPaths.add(0, "classpath:org/onebusaway/container/application-context-common.xml");
            ConfigurableApplicationContext context = ContainerLibrary.createContext(contextPaths);
            GtfsBundles bundles = (GtfsBundles)context.getBean("gtfs-bundles");
            allBundles.addAll(bundles.getBundles());
        }
        return allBundles;
    }
}

