/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.utilities;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.model.XYPoint;
import org.onebusaway.geospatial.services.UTMLibrary;
import org.onebusaway.geospatial.services.UTMProjection;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.transit_data_federation.bundle.model.GtfsBundle;
import org.onebusaway.transit_data_federation.bundle.utilities.UtilityLibrary;

public class GtfsComputePolylineBoundaryForStopsMain {
    private static final String ARG_FORMAT = "format";

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        GtfsComputePolylineBoundaryForStopsMain main = new GtfsComputePolylineBoundaryForStopsMain();
        main.run(args);
    }

    public void run(String[] args) throws IOException {
        try {
            GnuParser parser = new GnuParser();
            Options options = new Options();
            this.buildOptions(options);
            CommandLine commandLine = parser.parse(options, args);
            String[] remainingArgs = commandLine.getArgs();
            if (remainingArgs.length < 2) {
                this.printUsage();
                System.exit(-1);
            }
            List<GtfsBundle> bundles = this.getGtfsBundlesFromCommandLine(remainingArgs);
            EFormat format = this.getFormat(commandLine);
            StopToPolygonEntityHandler handler = new StopToPolygonEntityHandler(2500.0);
            for (GtfsBundle bundle : bundles) {
                System.err.println(bundle.getPath());
                GtfsReader reader = new GtfsReader();
                reader.addEntityHandler((EntityHandler)handler);
                reader.setInputLocation(bundle.getPath());
                if (bundle.getDefaultAgencyId() != null) {
                    reader.setDefaultAgencyId(bundle.getDefaultAgencyId());
                }
                reader.readEntities(Stop.class);
            }
            PrintWriter out = this.getOutputAsPrinter(remainingArgs[remainingArgs.length - 1]);
            switch (format) {
                case OSM: {
                    this.handleOutputAsOSMPolygon(out, handler);
                    break;
                }
                case TEXT: {
                    this.handleOutputAsText(out, handler);
                }
            }
            out.close();
        }
        catch (ParseException ex) {
            System.err.println(ex.getLocalizedMessage());
            this.printUsage();
            System.exit(-1);
        }
        System.exit(0);
    }

    private PrintWriter getOutputAsPrinter(String path) throws IOException {
        if (path.equals("-")) {
            return new PrintWriter(new OutputStreamWriter(System.out));
        }
        return new PrintWriter(new FileWriter(path));
    }

    private void handleOutputAsOSMPolygon(PrintWriter out, StopToPolygonEntityHandler handler) throws IOException {
        Geometry geometry = handler.getGeometry();
        UTMProjection proj = handler.getProjection();
        out.println("polygon");
        AtomicInteger index = new AtomicInteger();
        this.printGeometry(out, geometry, proj, index, false);
        out.println("END");
    }

    private void handleOutputAsText(PrintWriter out, StopToPolygonEntityHandler handler) {
        Geometry geometry = handler.getGeometry();
        UTMProjection proj = handler.getProjection();
        out.println("polygon");
        AtomicInteger index = new AtomicInteger();
        this.printGeometry(out, geometry, proj, index, true);
        out.println("END");
    }

    private List<GtfsBundle> getGtfsBundlesFromCommandLine(String[] args) {
        ArrayList<String> subList = new ArrayList<String>();
        for (int i = 0; i < args.length - 1; ++i) {
            subList.add(args[i]);
        }
        return UtilityLibrary.getGtfsBundlesForArguments(subList);
    }

    private void printGeometry(PrintWriter out, Geometry geometry, UTMProjection proj, AtomicInteger index, boolean latFirst) {
        if (geometry instanceof Polygon) {
            this.printPolygon(out, (Polygon)geometry, proj, index, latFirst);
        } else if (geometry instanceof MultiPolygon) {
            this.printMultiPolygon(out, (MultiPolygon)geometry, proj, index, latFirst);
        } else {
            System.err.println("unknown geometry: " + geometry);
        }
    }

    private void printMultiPolygon(PrintWriter out, MultiPolygon multi, UTMProjection proj, AtomicInteger index, boolean latFirst) {
        for (int i = 0; i < multi.getNumGeometries(); ++i) {
            this.printGeometry(out, multi.getGeometryN(i), proj, index, latFirst);
        }
    }

    private void printPolygon(PrintWriter out, Polygon poly, UTMProjection proj, AtomicInteger index, boolean latFirst) {
        out.println(index.incrementAndGet());
        this.printLineString(out, proj, poly.getExteriorRing(), latFirst);
        out.println("END");
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            out.println("!" + index.incrementAndGet());
            this.printLineString(out, proj, poly.getInteriorRingN(i), latFirst);
            out.println("END");
        }
    }

    private void printLineString(PrintWriter out, UTMProjection proj, LineString line, boolean latFirst) {
        for (int i = 0; i < line.getNumPoints(); ++i) {
            Point point = line.getPointN(i);
            XYPoint p = new XYPoint(point.getX(), point.getY());
            CoordinatePoint c = proj.reverse(p);
            if (latFirst) {
                out.println(c.getLat() + " " + c.getLon());
                continue;
            }
            out.println(c.getLon() + " " + c.getLat());
        }
    }

    protected void buildOptions(Options options) {
        options.addOption(ARG_FORMAT, true, "");
    }

    protected void printUsage() {
        System.err.println("usage: [-format osm|xml|encoded] data-sources.xml [data-sources.xml ...] output_path");
    }

    protected EFormat getFormat(CommandLine cli) {
        if (!cli.hasOption(ARG_FORMAT)) {
            return EFormat.XML;
        }
        String format = cli.getOptionValue(ARG_FORMAT);
        if (format.equals("osm")) {
            return EFormat.OSM;
        }
        if (format.equals("xml")) {
            return EFormat.XML;
        }
        if (format.equals("text")) {
            return EFormat.TEXT;
        }
        if (format.equals("encoded")) {
            return EFormat.ENCODED;
        }
        throw new IllegalStateException("unknown format: " + format);
    }

    private static class StopToPolygonEntityHandler
    implements EntityHandler {
        private GeometryFactory _factory = new GeometryFactory();
        private UTMProjection _projection;
        private double _bufferRadiusInMeters;
        private Geometry _geometry;

        public StopToPolygonEntityHandler(double bufferRadiusInMeters) {
            this._bufferRadiusInMeters = bufferRadiusInMeters;
        }

        public Geometry getGeometry() {
            return this._geometry;
        }

        public UTMProjection getProjection() {
            return this._projection;
        }

        public void handleEntity(Object bean) {
            Stop stop = (Stop)bean;
            if (this._projection == null) {
                int zone = UTMLibrary.getUTMZoneForLongitude((double)stop.getLon());
                this._projection = new UTMProjection(zone);
            }
            XYPoint point = this._projection.forward(new CoordinatePoint(stop.getLat(), stop.getLon()));
            Point p = this._factory.createPoint(new Coordinate(point.getX(), point.getY()));
            Geometry geometry = p.buffer(this._bufferRadiusInMeters).getEnvelope();
            this._geometry = this._geometry == null ? geometry : this._geometry.union(geometry);
        }
    }

    private static enum EFormat {
        OSM,
        XML,
        ENCODED,
        TEXT;

    }
}

