/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.transit_graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.onebusaway.container.ConfigurationParameter;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data_federation.bundle.services.UniqueService;
import org.onebusaway.transit_data_federation.bundle.tasks.ShapePointHelper;
import org.onebusaway.transit_data_federation.impl.transit_graph.RouteEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.StopTimeEntriesFactory;
import org.onebusaway.transit_data_federation.impl.transit_graph.StopTimeEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TransitGraphImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TripEntryImpl;
import org.onebusaway.transit_data_federation.model.ShapePoints;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.util.LoggingIntervalUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TripEntriesFactory {
    private Logger _log = LoggerFactory.getLogger(TripEntriesFactory.class);
    private UniqueService _uniqueService;
    private GtfsRelationalDao _gtfsDao;
    private StopTimeEntriesFactory _stopTimeEntriesFactory;
    private ShapePointHelper _shapePointsHelper;
    private ExecutorService _executor = null;
    private boolean _throwExceptionOnInvalidStopToShapeMappingException = false;

    @Autowired
    public void setUniqueService(UniqueService uniqueService) {
        this._uniqueService = uniqueService;
    }

    @Autowired
    public void setShapePointHelper(ShapePointHelper shapePointsHelper) {
        this._shapePointsHelper = shapePointsHelper;
    }

    @Autowired
    public void setGtfsDao(GtfsRelationalDao gtfsDao) {
        this._gtfsDao = gtfsDao;
    }

    @Autowired
    public void setStopTimeEntriesFactory(StopTimeEntriesFactory stopTimeEntriesFactory) {
        this._stopTimeEntriesFactory = stopTimeEntriesFactory;
    }

    @ConfigurationParameter
    public void setThrowExceptionOnInvalidStopToShapeMappingException(boolean throwExceptionOnInvalidStopToShapeMappingException) {
        this._throwExceptionOnInvalidStopToShapeMappingException = throwExceptionOnInvalidStopToShapeMappingException;
    }

    public void processTrips(TransitGraphImpl graph) {
        this.setupExecutor();
        Collection routes = this._gtfsDao.getAllRoutes();
        int routeIndex = 0;
        ArrayList<JobResult> results = new ArrayList<JobResult>();
        for (Route route : routes) {
            JobResult result = new JobResult();
            ProcessRouteJob jt = new ProcessRouteJob(graph, route, ++routeIndex, result);
            results.add(result);
            this._executor.submit(jt);
        }
        this.waitOnExector(results);
        if (this._stopTimeEntriesFactory.getInvalidStopToShapeMappingExceptionCount() > 0L && this._throwExceptionOnInvalidStopToShapeMappingException) {
            throw new IllegalStateException("Multiple instances of InvalidStopToShapeMappingException thrown: count=" + this._stopTimeEntriesFactory.getInvalidStopToShapeMappingExceptionCount() + ".  For more information on errors of this kind, see:\n  https://github.com/OneBusAway/onebusaway-application-modules/wiki/Stop-to-Shape-Matching");
        }
        graph.refreshTripMapping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnExector(List<JobResult> results) {
        int i = 0;
        try {
            for (JobResult result : results) {
                while (!result.isDone()) {
                    try {
                        this._log.info("waiting on result {} of {}", (Object)i, (Object)results.size());
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        this._log.error("interrupted and exiting");
                        if (this._executor != null) {
                            try {
                                this._executor.shutdown();
                                this._executor.awaitTermination(1L, TimeUnit.MINUTES);
                                this._executor.shutdownNow();
                            }
                            catch (Exception e2) {
                                return;
                            }
                        }
                        return;
                    }
                }
                ++i;
            }
            this._log.info("verified {} complete of {}", (Object)i, (Object)results.size());
        }
        finally {
            if (this._executor != null) {
                try {
                    this._executor.shutdown();
                    this._executor.awaitTermination(1L, TimeUnit.MINUTES);
                    this._executor.shutdownNow();
                }
                catch (Exception e) {
                    return;
                }
            }
        }
    }

    private void setupExecutor() {
        if (this._executor == null) {
            int cpus = 1;
            this._executor = Executors.newFixedThreadPool(cpus);
            this._log.info("created threadpool of " + cpus);
        }
    }

    private void processRoute(TransitGraphImpl graph, Route route, int routeIndex) {
        List tripsForRoute = this._gtfsDao.getTripsForRoute(route);
        int tripCount = tripsForRoute.size();
        int logInterval = LoggingIntervalUtil.getAppropriateLoggingInterval((int)(tripCount * 10));
        this._log.info("trips to process: " + tripCount);
        int tripIndex = 0;
        RouteEntryImpl routeEntry = graph.getRouteForId(route.getId());
        ArrayList<TripEntryImpl> tripEntries = new ArrayList<TripEntryImpl>();
        for (Trip trip : tripsForRoute) {
            TripEntryImpl tripEntry;
            if (++tripIndex % logInterval == 0) {
                this._log.info("trips processed: " + tripIndex + "/" + tripsForRoute.size());
            }
            if ((tripEntry = this.processTrip(graph, trip)) == null) continue;
            tripEntry.setRoute(routeEntry);
            tripEntries.add(tripEntry);
        }
        tripEntries.trimToSize();
        routeEntry.setTrips(tripEntries);
        this._log.info("complete {}", (Object)routeIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TripEntryImpl processTrip(TransitGraphImpl graph, Trip trip) {
        List stopTimesForTrip;
        List stopTimes = null;
        GtfsRelationalDao gtfsRelationalDao = this._gtfsDao;
        synchronized (gtfsRelationalDao) {
            stopTimes = this._gtfsDao.getStopTimesForTrip(trip);
        }
        if (stopTimes.isEmpty()) {
            return null;
        }
        ShapePoints shapePoints = null;
        if (trip.getShapeId() != null) {
            shapePoints = this._shapePointsHelper.getShapePointsForShapeId(trip.getShapeId());
        }
        Agency agency = trip.getRoute().getAgency();
        TimeZone tz = TimeZone.getTimeZone(agency.getTimezone());
        LocalizedServiceId lsid = new LocalizedServiceId(trip.getServiceId(), tz);
        TripEntryImpl tripEntry = new TripEntryImpl();
        tripEntry.setId(trip.getId());
        tripEntry.setDirectionId(this.unique(trip.getDirectionId()));
        tripEntry.setServiceId(this.unique(lsid));
        if (shapePoints != null && !shapePoints.isEmpty()) {
            tripEntry.setShapeId(this.unique(trip.getShapeId()));
        }
        if ((stopTimesForTrip = this._stopTimeEntriesFactory.processStopTimes(graph, stopTimes, tripEntry, shapePoints)) == null || stopTimesForTrip.size() < 2) {
            this._log.error("trip " + trip.getId() + " missing stops!");
            return null;
        }
        double tripDistance = this.getTripDistance(stopTimesForTrip, shapePoints);
        tripEntry.setTotalTripDistance(tripDistance);
        tripEntry.setStopTimes(stopTimesForTrip);
        graph.putTripEntry(tripEntry);
        return tripEntry;
    }

    private List<StopTimeEntry> cast(List<StopTimeEntryImpl> stopTimesForTrip) {
        ArrayList<StopTimeEntry> stopTimes = new ArrayList<StopTimeEntry>(stopTimesForTrip.size());
        for (StopTimeEntryImpl stopTime : stopTimesForTrip) {
            stopTimes.add((StopTimeEntry)stopTime);
        }
        return stopTimes;
    }

    private double getTripDistance(List<StopTimeEntry> stopTimes, ShapePoints shapePoints) {
        StopTimeEntry lastStopTime = null;
        try {
            lastStopTime = stopTimes.get(stopTimes.size() - 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this._log.error("FATAL:  missing last stop " + stopTimes);
        }
        if (shapePoints != null) {
            double[] distances = shapePoints.getDistTraveled();
            double distance = distances[shapePoints.getSize() - 1];
            return Math.max(lastStopTime.getShapeDistTraveled(), distance);
        }
        return lastStopTime.getShapeDistTraveled();
    }

    private <T> T unique(T value) {
        return this._uniqueService.unique(value);
    }

    public class JobResult {
        private boolean done = false;

        public void setDone() {
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }
    }

    public class ProcessRouteJob
    implements Runnable {
        private TransitGraphImpl graph;
        private Route route;
        private int routeIndex;
        private JobResult result;

        public ProcessRouteJob(TransitGraphImpl graph, Route route, int routeIndex, JobResult result) {
            this.graph = graph;
            this.route = route;
            this.routeIndex = routeIndex;
            this.result = result;
        }

        @Override
        public void run() {
            try {
                TripEntriesFactory.this.processRoute(this.graph, this.route, this.routeIndex);
            }
            catch (Throwable t) {
                TripEntriesFactory.this._log.error("pr blew {}", (Object)t, (Object)t);
            }
            finally {
                this.result.setDone();
            }
        }
    }
}

