/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.transit_graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceIdOverlapCache {
    private CalendarService _calendarService;
    private Map<Set<LocalizedServiceId>, List<ServiceIdActivation>> _cache = new HashMap<Set<LocalizedServiceId>, List<ServiceIdActivation>>();

    @Autowired
    public void setCalendarService(CalendarService calendarService) {
        this._calendarService = calendarService;
    }

    public List<ServiceIdActivation> getOverlappingServiceIdCombinations(Set<LocalizedServiceId> serviceIds) {
        List<ServiceIdActivation> combinations = this._cache.get(serviceIds);
        if (combinations == null) {
            combinations = this.computeCombinationsInternal(serviceIds);
            this._cache.put(new HashSet<LocalizedServiceId>(serviceIds), combinations);
        }
        return combinations;
    }

    private List<ServiceIdActivation> computeCombinationsInternal(Set<LocalizedServiceId> serviceIds) {
        FactoryMap serviceIdsByServiceDate = new FactoryMap(new HashSet());
        for (LocalizedServiceId lsid : serviceIds) {
            AgencyAndId serviceId = lsid.getId();
            for (ServiceDate serviceDate : this._calendarService.getServiceDatesForServiceId(serviceId)) {
                ((Set)serviceIdsByServiceDate.get(serviceDate)).add(lsid);
            }
        }
        HashSet sets = new HashSet();
        sets.addAll(serviceIdsByServiceDate.values());
        ArrayList<ServiceIdActivation> combinations = new ArrayList<ServiceIdActivation>();
        for (Set activeServiceIds : sets) {
            HashSet<LocalizedServiceId> inactiveServiceIds = new HashSet<LocalizedServiceId>();
            for (Set combo2 : sets) {
                if (!this.isSubset(activeServiceIds, combo2)) continue;
                inactiveServiceIds.addAll(combo2);
            }
            inactiveServiceIds.removeAll(activeServiceIds);
            combinations.add(new ServiceIdActivation(this.list(activeServiceIds), this.list(inactiveServiceIds)));
        }
        Collections.sort(combinations);
        return combinations;
    }

    private <T> boolean isSubset(Set<T> potentialSubset, Set<T> potentialSuperset) {
        if (potentialSubset.size() >= potentialSuperset.size()) {
            return false;
        }
        for (T element : potentialSubset) {
            if (potentialSuperset.contains(element)) continue;
            return false;
        }
        return true;
    }

    private List<LocalizedServiceId> list(Collection<LocalizedServiceId> combination) {
        ArrayList<LocalizedServiceId> serviceIds = new ArrayList<LocalizedServiceId>(combination);
        Collections.sort(serviceIds);
        return serviceIds;
    }
}

