/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.transit_graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data_federation.bundle.services.UniqueService;
import org.onebusaway.transit_data_federation.impl.transit_graph.AgencyEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.RouteCollectionEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.RouteEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TransitGraphImpl;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteCollectionEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RouteCollectionEntriesFactory {
    private GtfsRelationalDao _gtfsDao;
    private UniqueService _uniqueService;
    private boolean _groupRoutesByShortName = false;

    @Autowired
    public void setGtfsDao(GtfsRelationalDao gtfsDao) {
        this._gtfsDao = gtfsDao;
    }

    @Autowired
    public void setUniqueService(UniqueService uniqueService) {
        this._uniqueService = uniqueService;
    }

    public void setGroupRoutesByShortName(boolean groupRoutesByShortName) {
        this._groupRoutesByShortName = groupRoutesByShortName;
    }

    public void processRouteCollections(TransitGraphImpl graph) {
        if (this._groupRoutesByShortName) {
            this.createRouteShortNameRouteCollectionMapping(graph);
        } else {
            this.createOneToOneRouteCollectionMapping(graph);
        }
        this.groupRouteCollectionsByAgencyId(graph);
        graph.refreshRouteCollectionMapping();
    }

    private void groupRouteCollectionsByAgencyId(TransitGraphImpl graph) {
        String agencyId;
        FactoryMap entriesByAgencyId = new FactoryMap(new ArrayList());
        for (RouteCollectionEntry routeCollectionEntry : graph.getAllRouteCollections()) {
            agencyId = routeCollectionEntry.getId().getAgencyId();
            ((ArrayList)entriesByAgencyId.get(agencyId)).add(routeCollectionEntry);
        }
        for (Map.Entry entry : entriesByAgencyId.entrySet()) {
            agencyId = (String)entry.getKey();
            ArrayList routeCollections = (ArrayList)entry.getValue();
            routeCollections.trimToSize();
            AgencyEntryImpl agencyEntry = graph.getAgencyForId(agencyId);
            agencyEntry.setRouteCollections((List)routeCollections);
        }
    }

    private void createOneToOneRouteCollectionMapping(TransitGraphImpl graph) {
        for (RouteEntryImpl routeEntry : graph.getRoutes()) {
            RouteCollectionEntryImpl routeCollectionEntry = new RouteCollectionEntryImpl();
            routeCollectionEntry.setId(routeEntry.getId());
            ArrayList<RouteEntryImpl> routes = new ArrayList<RouteEntryImpl>();
            routes.add(routeEntry);
            routes.trimToSize();
            routeCollectionEntry.setChildren(routes);
            graph.putRouteCollectionEntry(routeCollectionEntry);
            routeEntry.setParent((RouteCollectionEntry)routeCollectionEntry);
        }
    }

    private void createRouteShortNameRouteCollectionMapping(TransitGraphImpl graph) {
        HashMap<AgencyAndId, ArrayList<RouteEntryImpl>> routesByKey = new HashMap<AgencyAndId, ArrayList<RouteEntryImpl>>();
        for (RouteEntryImpl routeEntryImpl : graph.getRoutes()) {
            Route route = this._gtfsDao.getRouteForId(routeEntryImpl.getId());
            AgencyAndId key = this.getRouteCollectionIdForRoute(route);
            ArrayList<RouteEntryImpl> forKey = (ArrayList<RouteEntryImpl>)routesByKey.get(key);
            if (forKey == null) {
                forKey = new ArrayList<RouteEntryImpl>();
                routesByKey.put(key, forKey);
            }
            forKey.add(routeEntryImpl);
        }
        for (Map.Entry entry : routesByKey.entrySet()) {
            AgencyAndId key = (AgencyAndId)entry.getKey();
            List routesForKey = (List)entry.getValue();
            ArrayList children = new ArrayList();
            children.addAll(routesForKey);
            children.trimToSize();
            key = this._uniqueService.unique(key);
            RouteCollectionEntryImpl routeCollectionEntry = new RouteCollectionEntryImpl();
            routeCollectionEntry.setId(key);
            routeCollectionEntry.setChildren(children);
            graph.putRouteCollectionEntry(routeCollectionEntry);
            for (RouteEntryImpl route : routesForKey) {
                route.setParent((RouteCollectionEntry)routeCollectionEntry);
            }
        }
    }

    private AgencyAndId getRouteCollectionIdForRoute(Route route) {
        String id = this.trim(route.getShortName());
        if (id == null || id.length() == 0) {
            id = route.getId().getId();
        }
        id = id.replace('/', '_');
        id = id.replace('\\', '_');
        return new AgencyAndId(route.getId().getAgencyId(), id);
    }

    private String trim(String value) {
        if (value == null) {
            return value;
        }
        return value.trim();
    }
}

