/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.transit_graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data_federation.bundle.tasks.transit_graph.BlockConfigurationEntriesFactory;
import org.onebusaway.transit_data_federation.impl.transit_graph.BlockEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TransitGraphImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TripEntryImpl;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.util.LoggingIntervalUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlockEntriesFactory {
    private Logger _log = LoggerFactory.getLogger(BlockEntriesFactory.class);
    private GtfsRelationalDao _gtfsDao;
    private BlockConfigurationEntriesFactory _blockConfigurationEntriesFactory;

    @Autowired
    public void setGtfsDao(GtfsRelationalDao gtfsDao) {
        this._gtfsDao = gtfsDao;
    }

    @Autowired
    public void setBlockConfigurationEntriesFactory(BlockConfigurationEntriesFactory blockConfigurationEntriesFactory) {
        this._blockConfigurationEntriesFactory = blockConfigurationEntriesFactory;
    }

    public void processBlocks(TransitGraphImpl graph) {
        Map<AgencyAndId, List<TripEntryImpl>> tripsByBlockId = this.getTripsByBlockId(graph);
        this.processBlockTrips(graph, tripsByBlockId);
    }

    private Map<AgencyAndId, List<TripEntryImpl>> getTripsByBlockId(TransitGraphImpl graph) {
        Collection routes = this._gtfsDao.getAllRoutes();
        int routeIndex = 0;
        FactoryMap tripsByBlockId = new FactoryMap(new ArrayList());
        for (Route route : routes) {
            this._log.info("routes: " + routeIndex++ + "/" + routes.size());
            List trips = this._gtfsDao.getTripsForRoute(route);
            for (Trip trip : trips) {
                TripEntryImpl tripEntry = graph.getTripEntryForId(trip.getId());
                if (tripEntry == null) continue;
                AgencyAndId blockId = trip.getId();
                if (trip.getBlockId() != null) {
                    blockId = new AgencyAndId(trip.getId().getAgencyId(), trip.getBlockId());
                }
                ((List)tripsByBlockId.get(blockId)).add(tripEntry);
            }
        }
        return tripsByBlockId;
    }

    private void processBlockTrips(TransitGraphImpl graph, Map<AgencyAndId, List<TripEntryImpl>> tripsByBlockId) {
        int blockIndex = 0;
        int logInterval = LoggingIntervalUtil.getAppropriateLoggingInterval((int)tripsByBlockId.keySet().size());
        for (Map.Entry<AgencyAndId, List<TripEntryImpl>> entry : tripsByBlockId.entrySet()) {
            if (blockIndex % logInterval == 0) {
                this._log.info("block: " + blockIndex + "/" + tripsByBlockId.size());
            }
            ++blockIndex;
            AgencyAndId blockId = entry.getKey();
            List<TripEntryImpl> tripsInBlock = entry.getValue();
            if (tripsInBlock.isEmpty()) {
                this._log.warn("no trips for block=" + blockId);
                continue;
            }
            BlockEntryImpl blockEntry = new BlockEntryImpl();
            blockEntry.setId(blockId);
            this._blockConfigurationEntriesFactory.processBlockConfigurations(blockEntry, tripsInBlock);
            graph.putBlockEntry(blockEntry);
            for (TripEntryImpl trip : tripsInBlock) {
                trip.setBlock((BlockEntry)blockEntry);
            }
        }
    }
}

