/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.stif.model;

import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.RunTripEntry;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.StifRecord;

public class TripRecord
implements StifRecord {
    private String signCode;
    private String blockNumber;
    private int originTime;
    private int tripType;
    private int destinationTime;
    private String originLocation;
    private String signCodeRoute;
    private String reliefRun;
    private String runNumber;
    private String previousRunNumber;
    private int reliefTime;
    private String reliefRunRoute;
    private String runRoute;
    private String nextTripOperatorRunNumber;
    private String nextTripOperatorRunRoute;
    private String nextTripOperatorDepotCode;
    private String previousRunRoute;
    private String destinationLocation;
    private int recoveryTime;
    private boolean lastTripInSequence;
    private boolean firstTripInSequence;
    private String depotCode;
    private String gtfsTripId;

    public void setSignCode(String signCode) {
        this.signCode = signCode.replaceAll("^0+", "");
    }

    public String getSignCode() {
        return this.signCode;
    }

    public void setBlockNumber(String blockNumber) {
        if (!"".equals(blockNumber)) {
            this.blockNumber = blockNumber;
        }
    }

    public String getBlockNumber() {
        return this.blockNumber;
    }

    public void setOriginTime(int seconds) {
        this.originTime = seconds;
    }

    public int getOriginTime() {
        return this.originTime;
    }

    public void setTripType(int tripType) {
        this.tripType = tripType;
    }

    public int getTripType() {
        return this.tripType;
    }

    public void setDestinationTime(int destinationTime) {
        this.destinationTime = destinationTime;
    }

    public int getDestinationTime() {
        return this.destinationTime;
    }

    public void setOriginLocation(String originLocation) {
        this.originLocation = originLocation;
    }

    public String getOriginLocation() {
        return this.originLocation;
    }

    public String getSignCodeRoute() {
        return this.signCodeRoute;
    }

    public void setSignCodeRoute(String signCodeRoute) {
        this.signCodeRoute = signCodeRoute.replaceFirst("^([a-zA-Z]+)0+", "$1").toUpperCase();
    }

    public String getReliefRunNumber() {
        if (this.reliefRun == null) {
            return this.runNumber;
        }
        return this.reliefRun;
    }

    public void setReliefRunNumber(String run) {
        this.reliefRun = run;
    }

    public String getRunNumber() {
        return this.runNumber;
    }

    public void setRunNumber(String run) {
        this.runNumber = run;
    }

    public String getPreviousRunNumber() {
        return this.previousRunNumber;
    }

    public String getPreviousRunRoute() {
        return this.previousRunRoute;
    }

    public String getPreviousRunId() {
        return RunTripEntry.createId(this.getPreviousRunRoute(), this.getPreviousRunNumber());
    }

    public void setPreviousRunNumber(String previousRun) {
        this.previousRunNumber = previousRun;
    }

    public void setReliefTime(int reliefTime) {
        this.reliefTime = reliefTime;
    }

    public int getReliefTime() {
        return this.reliefTime;
    }

    public String getRunRoute() {
        return this.runRoute;
    }

    public String getReliefRunRoute() {
        return this.reliefRunRoute;
    }

    public String getRunId() {
        return RunTripEntry.createId(this.getRunRoute(), this.getRunNumber());
    }

    public String getRunIdWithDepot() {
        if ("MISC".equals(this.getRunRoute())) {
            return RunTripEntry.createId(this.getRunRoute() + "-" + this.getDepotCode(), this.getRunNumber());
        }
        return RunTripEntry.createId(this.getRunRoute(), this.getRunNumber());
    }

    public String getReliefRunId() {
        return RunTripEntry.createId(this.getReliefRunRoute(), this.getReliefRunNumber());
    }

    public void setReliefRunRoute(String reliefRunRoute) {
        this.reliefRunRoute = reliefRunRoute;
    }

    public void setRunRoute(String runRoute) {
        this.runRoute = runRoute;
    }

    public void setNextTripOperatorRunNumber(String runNumber) {
        this.nextTripOperatorRunNumber = runNumber;
    }

    public String getNextTripOperatorRunId() {
        return RunTripEntry.createId(this.getNextTripOperatorRunRoute(), this.getNextTripOperatorRunNumber());
    }

    public String getNextTripOperatorRunIdWithDepot() {
        if ("MISC".equals(this.getNextTripOperatorRunRoute())) {
            return RunTripEntry.createId(this.getNextTripOperatorRunRoute() + "-" + this.getDepotCode(), this.getNextTripOperatorRunNumber());
        }
        return RunTripEntry.createId(this.getNextTripOperatorRunRoute(), this.getNextTripOperatorRunNumber());
    }

    public String getNextTripOperatorRunNumber() {
        return this.nextTripOperatorRunNumber;
    }

    public String getNextTripOperatorRunRoute() {
        return this.nextTripOperatorRunRoute;
    }

    public void setNextTripOperatorRunRoute(String route) {
        this.nextTripOperatorRunRoute = route;
    }

    public void setPreviousRunRoute(String route) {
        this.previousRunRoute = route;
    }

    public String getDestinationLocation() {
        return this.destinationLocation;
    }

    public void setDestinationLocation(String destinationLocation) {
        this.destinationLocation = destinationLocation;
    }

    public int getRecoveryTime() {
        return this.recoveryTime;
    }

    public void setRecoveryTime(int recoveryTime) {
        this.recoveryTime = recoveryTime;
    }

    public void setLastTripInSequence(boolean last) {
        this.lastTripInSequence = last;
    }

    public void setFirstTripInSequence(boolean first) {
        this.firstTripInSequence = first;
    }

    public boolean isFirstTripInSequence() {
        return this.firstTripInSequence;
    }

    public boolean isLastTripInSequence() {
        return this.lastTripInSequence;
    }

    public String getDepotCode() {
        return this.depotCode;
    }

    public void setDepotCode(String depotCode) {
        this.depotCode = depotCode;
    }

    public void setGtfsTripId(String gtfsTripId) {
        this.gtfsTripId = gtfsTripId;
    }

    public String getGtfsTripId() {
        return this.gtfsTripId;
    }

    public String getNextTripOperatorDepotCode() {
        return this.nextTripOperatorDepotCode;
    }

    public void setNextTripOperatorDepotCode(String depotCode) {
        this.nextTripOperatorDepotCode = depotCode;
    }
}

