/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.stif.model;

import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.ServiceCode;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.StifFieldDefinition;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.StifFieldSetter;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.StifRecordFactory;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.TimetableFieldSetter;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.TimetableRecord;

public class TimetableRecordFactory
extends StifRecordFactory<TimetableRecord> {
    private static StifFieldDefinition[] fields = new StifFieldDefinition[]{new FieldDef(2, "record type", null), new FieldDef(4, "depot code", null), new FieldDef(2, "borough code", null), new FieldDef(6, "route identifier", new TimetableFieldSetter(){

        @Override
        public void setField(TimetableRecord record) {
            record.setRouteIdentifier(this.getStringData());
        }
    }), new FieldDef(2, "service code", new TimetableFieldSetter(){

        @Override
        public void setField(TimetableRecord record) {
            record.setServiceCode(ServiceCode.getServiceCodeForId(this.getStringData()));
        }
    }), new FieldDef(24, "depot description", null), new FieldDef(24, "route description", null), new FieldDef(8, "schedule number", null), new FieldDef(4, "version number", null), new FieldDef(1, "empty", null), new FieldDef(1, "stif type code", null), new FieldDef(1, "empty", null), new FieldDef(2, "organization", new TimetableFieldSetter(){

        @Override
        public void setField(TimetableRecord record) {
            String org = this.getStringData();
            if ("TA".equals(org) || "OA".equals(org)) {
                record.setAgencyId("MTA NYCT");
            } else if ("MB".equals(org) || "BC".equals(org)) {
                record.setAgencyId("MTABC");
            } else {
                record.setAgencyId(org);
            }
        }
    }), new FieldDef(2, "empty", null), new FieldDef(8, "generation date", null), new FieldDef(1, "empty", null), new FieldDef(2, "additional depot code 1", null), new FieldDef(1, "empty", null), new FieldDef(2, "additional depot code 2", null), new FieldDef(1, "empty", null), new FieldDef(2, "additional depot code 3", null), new FieldDef(1, "empty", null), new FieldDef(2, "additional depot code 4", null), new FieldDef(1, "empty", null), new FieldDef(6, "additional schedule number 1", null), new FieldDef(1, "empty", null), new FieldDef(6, "additional schedule number 2", null), new FieldDef(1, "empty", null), new FieldDef(6, "additional schedule number 3", null), new FieldDef(1, "empty", null), new FieldDef(6, "additional schedule number 4", null), new FieldDef(14, "(fields skipped)", null), new FieldDef(8, "holiday code", new TimetableFieldSetter(){

        @Override
        public void setField(TimetableRecord record) {
            String data;
            if (!(record.getServiceCode() != null && record.getServiceCode().isHoliday() || (data = this.getStringData()) == null || data.length() <= 0)) {
                record.setServiceCode(ServiceCode.getServiceCodeForId(data));
            }
        }
    })};

    @Override
    public TimetableRecord createEmptyRecord() {
        return new TimetableRecord();
    }

    @Override
    public StifFieldDefinition<TimetableRecord>[] getFields() {
        return fields;
    }

    static class FieldDef
    extends StifFieldDefinition<TimetableRecord> {
        public FieldDef(int length, String name, StifFieldSetter<TimetableRecord> setter) {
            super(length, name, setter);
        }
    }
}

