/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.stif.model;

import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.StifRecord;

public abstract class StifFieldSetter<T extends StifRecord> {
    protected byte[] bytes;
    protected int start;
    protected int end;

    public void setData(byte[] bytes, int start, int end) {
        this.bytes = bytes;
        this.start = start;
        this.end = end;
    }

    public abstract void setField(T var1);

    public String getStringDataUppercased() {
        return this.getStringData().toUpperCase();
    }

    public String getStringData() {
        if (this.start > this.bytes.length) {
            return "";
        }
        if (this.end > this.bytes.length) {
            return new String(this.bytes, this.start, this.bytes.length - this.start).trim();
        }
        return new String(this.bytes, this.start, this.end - this.start).trim();
    }

    public int getInteger() {
        return Integer.parseInt(this.getStringData());
    }

    public int getIntegerSafe() {
        String data = this.getStringData();
        try {
            return Integer.parseInt(data);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public int getTimeFromCentiminutesSafe() {
        float centiminutes = this.getIntegerSafe();
        if (centiminutes == -1.0f) {
            return -1;
        }
        return (int)Math.round((double)centiminutes * 60.0 / 100.0);
    }

    public float getDecimalFixedPoint(int digits) {
        while (this.bytes[this.start] == 32) {
            ++this.start;
        }
        if (this.bytes[this.start] == 45) {
            ++digits;
        }
        String beforePoint = new String(this.bytes, this.start, digits).trim();
        String afterPoint = new String(this.bytes, this.start + digits, this.end - this.start - digits).trim();
        return Float.parseFloat(beforePoint + "." + afterPoint);
    }

    public boolean getBoolean() {
        while (this.bytes[this.start] == 32) {
            ++this.start;
        }
        return this.bytes[this.start] == 89;
    }
}

