/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.stif.model;

import com.google.common.collect.ComparisonChain;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.ReliefState;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;

public class RunTripEntry
implements Comparable<RunTripEntry> {
    private TripEntry entry;
    private String runId;
    private String runRoute;
    private String runNumber;
    private String runDepot;
    private int reliefTime = -1;
    private ReliefState relief;

    public static String createId(String route, String number) {
        if (StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)route)) {
            return null;
        }
        Object[] tmpRun = new String[]{route, number};
        return StringUtils.join((Object[])tmpRun, (String)"-");
    }

    public RunTripEntry(TripEntry entry, String runNumber, String runRoute, String runDepot, int reliefTime, ReliefState relief) {
        this.entry = entry;
        this.runNumber = runNumber;
        this.runRoute = runRoute;
        this.runDepot = runDepot;
        this.runId = runDepot == null ? RunTripEntry.createId(runRoute, runNumber) : RunTripEntry.createId(runRoute + "-" + runDepot, runNumber);
        this.reliefTime = reliefTime;
        this.relief = relief;
    }

    public int getStartTime() {
        if (this.getRelief() == ReliefState.AFTER_RELIEF) {
            return this.reliefTime;
        }
        return ((StopTimeEntry)this.entry.getStopTimes().get(0)).getArrivalTime();
    }

    public int getStopTime() {
        int lastTime = this.reliefTime;
        if (lastTime < 0) {
            List stopTimes = this.entry.getStopTimes();
            StopTimeEntry lastStopTime = (StopTimeEntry)stopTimes.get(stopTimes.size() - 1);
            lastTime = lastStopTime.getDepartureTime();
        }
        return lastTime;
    }

    @Override
    public int compareTo(RunTripEntry other) {
        if (this == other) {
            return 0;
        }
        int res = ComparisonChain.start().compare((Comparable)this.entry.getId(), (Comparable)other.getTripEntry().getId()).compare((Comparable)((Object)this.runId), (Comparable)((Object)other.runId)).compare(this.reliefTime, other.reliefTime).compare((Comparable)((Object)this.relief), (Comparable)((Object)other.relief)).result();
        return res;
    }

    public TripEntry getTripEntry() {
        return this.entry;
    }

    public String getRunId() {
        return this.runId;
    }

    public String getRunNumber() {
        return this.runNumber;
    }

    public String getRunRoute() {
        return this.runRoute;
    }

    public ReliefState getRelief() {
        return this.relief;
    }

    public void setRelief(ReliefState relief) {
        this.relief = relief;
    }

    public String toString() {
        return "RunTripEntry(" + this.entry + "," + this.runId + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
        result = 31 * result + (this.runId == null ? 0 : this.runId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunTripEntry)) {
            return false;
        }
        RunTripEntry other = (RunTripEntry)obj;
        if (this.entry == null ? other.entry != null : !this.entry.equals(other.entry)) {
            return false;
        }
        return !(this.runId == null ? other.runId != null : !this.runId.equals(other.runId));
    }
}

