/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.stif;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.locationtech.jts.geom.Coordinate;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.transit_data.model.oba.RunData;
import org.onebusaway.transit_data_federation.bundle.tasks.MultiCSVLogger;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.NonRevenueStopData;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.NonRevenueStopOrder;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.RawRunData;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.StifRecordReader;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.StifTrip;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.StifTripLoaderSupport;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.StifTripType;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.TripIdentifier;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.EventRecord;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.GeographyRecord;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.ServiceCode;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.SignCodeRecord;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.StifRecord;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.TimetableRecord;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.TripRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StifTripLoader {
    private static final Logger _log = LoggerFactory.getLogger(StifTripLoader.class);
    private StifTripLoaderSupport support = new StifTripLoaderSupport();
    private Map<String, List<AgencyAndId>> tripIdsBySignCode = new HashMap<String, List<AgencyAndId>>();
    private int _tripsCount = 0;
    private int _tripsWithoutMatchCount = 0;
    private Map<AgencyAndId, GeographyRecord> geographyRecordsByBoxId = new HashMap<AgencyAndId, GeographyRecord>();
    private Map<AgencyAndId, RunData> runsForTrip = new HashMap<AgencyAndId, RunData>();
    private Map<Trip, RawRunData> rawRunDataByTrip = new HashMap<Trip, RawRunData>();
    private Map<ServiceCode, List<StifTrip>> rawData = new HashMap<ServiceCode, List<StifTrip>>();
    private Map<AgencyAndId, List<NonRevenueStopData>> nonRevenueStopDataByTripId = new HashMap<AgencyAndId, List<NonRevenueStopData>>();
    private MultiCSVLogger csvLogger;
    private Pattern oldNYCTServiceIdFormat = Pattern.compile(".*[0-9]{8}[A-Z]{2}$");
    private Map<DuplicateTripCheckKey, StifTrip> tripsByRunAndStartTime = new HashMap<DuplicateTripCheckKey, StifTrip>();

    @Autowired
    public void setGtfsDao(GtfsMutableRelationalDao dao) {
        this.support.setGtfsDao(dao);
    }

    public Map<String, List<AgencyAndId>> getTripMapping() {
        return this.tripIdsBySignCode;
    }

    public Map<AgencyAndId, GeographyRecord> getGeographyRecordsByBoxId() {
        return this.geographyRecordsByBoxId;
    }

    public int getTripsCount() {
        return this._tripsCount;
    }

    public int getTripsWithoutMatchCount() {
        return this._tripsWithoutMatchCount;
    }

    public void run(File path) {
        try {
            _log.info("loading stif from " + path.getAbsolutePath());
            InputStream in = new FileInputStream(path);
            if (path.getName().endsWith(".gz")) {
                in = new GZIPInputStream(in);
            }
            this.run(in, path);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading " + path, e);
        }
    }

    public void run(InputStream stream, File path) {
        boolean warned = false;
        int lineNumber = 0;
        int tripLineNumber = 0;
        TripRecord tripRecord = null;
        EventRecord eventRecord = null;
        EventRecord firstEventRecord = null;
        EventRecord firstNonRevEventRecord = null;
        EventRecord lastNonRevEventRecord = null;
        try {
            StifRecordReader reader = new StifRecordReader(stream);
            ServiceCode serviceCode = null;
            String agencyId = null;
            boolean isBusCo = false;
            while (true) {
                StifRecord record = reader.read();
                ++lineNumber;
                if (record != null) {
                    if (record instanceof TimetableRecord) {
                        TimetableRecord timetableRecord = (TimetableRecord)record;
                        serviceCode = timetableRecord.getServiceCode();
                        agencyId = timetableRecord.getAgencyId();
                        isBusCo = "MTABC".equals(agencyId);
                        if (this.rawData.containsKey((Object)serviceCode)) continue;
                        this.rawData.put(serviceCode, new ArrayList());
                        continue;
                    }
                    if (record instanceof GeographyRecord) {
                        GeographyRecord geographyRecord = (GeographyRecord)record;
                        this.geographyRecordsByBoxId.put(new AgencyAndId(agencyId, geographyRecord.getBoxID()), geographyRecord);
                        this.support.putStopIdForLocation(geographyRecord.getIdentifier(), geographyRecord.getBoxID());
                        continue;
                    }
                    if (record instanceof EventRecord) {
                        EventRecord possibleEventRecord;
                        if (tripRecord == null || (possibleEventRecord = (EventRecord)record).getLocation() == null) continue;
                        if (!possibleEventRecord.isRevenue()) {
                            lastNonRevEventRecord = possibleEventRecord;
                            if (firstNonRevEventRecord != null || firstEventRecord != null) continue;
                            firstNonRevEventRecord = lastNonRevEventRecord;
                            lastNonRevEventRecord = null;
                            continue;
                        }
                        eventRecord = possibleEventRecord;
                        if (firstEventRecord == null) {
                            firstEventRecord = eventRecord;
                        }
                    }
                    if (record instanceof TripRecord || record instanceof SignCodeRecord) {
                        List<AgencyAndId> sctrips;
                        DuplicateTripCheckKey key;
                        StifTrip oldTrip;
                        TripIdentifier tripIdentifier;
                        if (tripRecord == null) {
                            if (record instanceof TripRecord) {
                                tripLineNumber = lineNumber;
                                tripRecord = (TripRecord)record;
                                lastNonRevEventRecord = null;
                                firstNonRevEventRecord = null;
                                firstEventRecord = null;
                                eventRecord = null;
                                continue;
                            }
                            tripRecord = null;
                            continue;
                        }
                        int tripType = tripRecord.getTripType();
                        boolean fakeDeadhead = false;
                        if (firstEventRecord == null && tripType != 2 && tripType != 3 && tripType != 4) {
                            _log.warn("Revenue trip at " + tripLineNumber + " in " + path + " has no revenue stops.  Using first/last stops from trip layer rather than event layer.");
                            fakeDeadhead = true;
                        }
                        if (tripType == 2 || tripType == 3 || tripType == 4 || fakeDeadhead) {
                            if (firstEventRecord != null) {
                                _log.warn("Non-revenue trip at " + tripLineNumber + " in " + path + " has a revenue stop");
                            }
                            StifTrip stifTrip = new StifTrip(tripRecord.getRunId(), tripRecord.getReliefRunId(), tripRecord.getNextTripOperatorRunId(), StifTripType.byValue(tripType), tripRecord.getSignCode());
                            stifTrip.agencyId = agencyId;
                            stifTrip.serviceCode = serviceCode;
                            stifTrip.depot = tripRecord.getDepotCode();
                            stifTrip.nextTripOperatorDepot = tripRecord.getNextTripOperatorDepotCode() != null ? tripRecord.getNextTripOperatorDepotCode() : tripRecord.getDepotCode();
                            stifTrip.firstStopTime = tripRecord.getOriginTime();
                            stifTrip.lastStopTime = tripRecord.getDestinationTime();
                            stifTrip.listedFirstStopTime = tripRecord.getOriginTime();
                            stifTrip.listedLastStopTime = tripRecord.getDestinationTime();
                            stifTrip.firstStop = this.support.getStopIdForLocation(tripRecord.getOriginLocation());
                            stifTrip.lastStop = this.support.getStopIdForLocation(tripRecord.getDestinationLocation());
                            stifTrip.recoveryTime = tripRecord.getRecoveryTime();
                            stifTrip.firstTripInSequence = tripRecord.isFirstTripInSequence();
                            stifTrip.lastTripInSequence = tripRecord.isLastTripInSequence();
                            stifTrip.signCodeRoute = tripRecord.getSignCodeRoute();
                            stifTrip.path = path;
                            stifTrip.lineNumber = tripLineNumber;
                            stifTrip.blockId = tripRecord.getBlockNumber();
                            this.rawData.get((Object)serviceCode).add(stifTrip);
                            if (record instanceof TripRecord) {
                                tripLineNumber = lineNumber;
                                tripRecord = (TripRecord)record;
                                lastNonRevEventRecord = null;
                                firstNonRevEventRecord = null;
                                firstEventRecord = null;
                                eventRecord = null;
                                continue;
                            }
                            tripRecord = null;
                            continue;
                        }
                        String runId = tripRecord.getRunIdWithDepot();
                        String reliefRunId = tripRecord.getReliefRunId();
                        String nextOperatorRunId = tripRecord.getNextTripOperatorRunIdWithDepot();
                        StifTrip stifTrip = new StifTrip(tripRecord.getRunId(), tripRecord.getReliefRunId(), tripRecord.getNextTripOperatorRunId(), StifTripType.byValue(tripType), tripRecord.getSignCode());
                        stifTrip.agencyId = agencyId;
                        stifTrip.serviceCode = serviceCode;
                        stifTrip.depot = tripRecord.getDepotCode();
                        stifTrip.nextTripOperatorDepot = tripRecord.getNextTripOperatorDepotCode() != null ? tripRecord.getNextTripOperatorDepotCode() : tripRecord.getDepotCode();
                        stifTrip.firstStopTime = firstEventRecord.getTime();
                        stifTrip.lastStopTime = eventRecord.getTime();
                        stifTrip.firstStop = this.support.getStopIdForLocation(firstEventRecord.getLocation());
                        stifTrip.lastStop = this.support.getStopIdForLocation(eventRecord.getLocation());
                        stifTrip.listedFirstStopTime = tripRecord.getOriginTime();
                        stifTrip.listedLastStopTime = tripRecord.getDestinationTime();
                        stifTrip.recoveryTime = tripRecord.getRecoveryTime();
                        stifTrip.firstTripInSequence = tripRecord.isFirstTripInSequence();
                        stifTrip.lastTripInSequence = tripRecord.isLastTripInSequence();
                        stifTrip.signCodeRoute = tripRecord.getSignCodeRoute();
                        stifTrip.path = path;
                        stifTrip.lineNumber = tripLineNumber;
                        stifTrip.blockId = tripRecord.getBlockNumber();
                        this.rawData.get((Object)serviceCode).add(stifTrip);
                        String destSignCode = tripRecord.getSignCode();
                        stifTrip.id = tripIdentifier = this.support.getIdentifierForStifTrip(tripRecord, stifTrip);
                        if (stifTrip.signCodeRoute == null || stifTrip.signCodeRoute.length() == 0) {
                            this.csvLogger.log("stif_trip_layers_with_missing_route.csv", tripIdentifier, path, tripLineNumber, "signCodeRoute");
                        }
                        if (stifTrip.getDsc() == null || stifTrip.getDsc().length() == 0) {
                            this.csvLogger.log("stif_trip_layers_with_missing_route.csv", tripIdentifier, path, tripLineNumber, "DSC");
                        }
                        if ((oldTrip = this.tripsByRunAndStartTime.get(key = new DuplicateTripCheckKey(stifTrip.runId, stifTrip.firstStopTime, stifTrip.serviceCode))) == null) {
                            this.tripsByRunAndStartTime.put(key, stifTrip);
                        } else {
                            this.csvLogger.log("trips_with_duplicate_run_and_start_time.csv", tripIdentifier, stifTrip.path, stifTrip.lineNumber, oldTrip.id, oldTrip.path, oldTrip.lineNumber);
                        }
                        List<Trip> trips = this.support.getTripsForIdentifier(tripIdentifier);
                        ++this._tripsCount;
                        if (trips == null || trips.isEmpty()) {
                            this.csvLogger.log("stif_trips_with_no_gtfs_match.csv", tripIdentifier, path, tripLineNumber);
                            if (!warned) {
                                warned = true;
                                _log.warn("gtfs trip not found for " + tripIdentifier);
                            }
                            ++this._tripsWithoutMatchCount;
                            if (record instanceof TripRecord) {
                                tripLineNumber = lineNumber;
                                tripRecord = (TripRecord)record;
                                lastNonRevEventRecord = null;
                                firstNonRevEventRecord = null;
                                firstEventRecord = null;
                                eventRecord = null;
                                continue;
                            }
                            tripRecord = null;
                            continue;
                        }
                        ArrayList<Trip> filtered = new ArrayList<Trip>();
                        for (Trip gtfsTrip : trips) {
                            boolean isNewMTAHastusGtfsFormat;
                            if (gtfsTrip.getId().getId().equals(tripRecord.getGtfsTripId())) {
                                this.addGtfsTrip(path, tripLineNumber, tripRecord, runId, reliefRunId, nextOperatorRunId, stifTrip, destSignCode, tripIdentifier, filtered, gtfsTrip);
                                continue;
                            }
                            String serviceId = gtfsTrip.getServiceId().getId();
                            Matcher m = this.oldNYCTServiceIdFormat.matcher(serviceId);
                            boolean bl = isNewMTAHastusGtfsFormat = !m.matches();
                            if (isBusCo || isNewMTAHastusGtfsFormat) {
                                ServiceCode tripServiceCode = ServiceCode.getServiceCodeForMTAHastusGTFS(serviceId);
                                if (serviceCode != tripServiceCode) {
                                    gtfsTrip = null;
                                }
                            } else {
                                Character dayCode1 = Character.valueOf(serviceId.charAt(serviceId.length() - 2));
                                Character dayCode2 = Character.valueOf(serviceId.charAt(serviceId.length() - 1));
                                if (stifTrip.firstStopTime < 0) {
                                    if (StifTripLoaderSupport.scheduleIdForGtfsDayCode(dayCode2.toString()) != serviceCode) {
                                        gtfsTrip = null;
                                    }
                                } else if (StifTripLoaderSupport.scheduleIdForGtfsDayCode(dayCode1.toString()) != serviceCode) {
                                    gtfsTrip = null;
                                }
                            }
                            if (gtfsTrip == null) continue;
                            this.addGtfsTrip(path, tripLineNumber, tripRecord, runId, reliefRunId, nextOperatorRunId, stifTrip, destSignCode, tripIdentifier, filtered, gtfsTrip);
                        }
                        if (filtered.size() == 0 && stifTrip.type == StifTripType.REVENUE && (destSignCode == null || destSignCode.length() == 0)) {
                            _log.warn("Revenue trip " + stifTrip + " did not have a DSC");
                            this.csvLogger.log("trips_with_null_dscs.csv", "(no GTFS trips)", tripIdentifier, path, tripLineNumber);
                        }
                        if ((sctrips = this.tripIdsBySignCode.get(destSignCode)) == null) {
                            sctrips = new ArrayList<AgencyAndId>();
                            this.tripIdsBySignCode.put(destSignCode, sctrips);
                        }
                        for (Trip trip : filtered) {
                            Coordinate c;
                            GeographyRecord geographyRecord;
                            AgencyAndId stopAgencyAndId;
                            String stopId;
                            sctrips.add(trip.getId());
                            if (firstNonRevEventRecord == null && lastNonRevEventRecord == null) continue;
                            if (!this.nonRevenueStopDataByTripId.containsKey(trip.getId())) {
                                this.nonRevenueStopDataByTripId.put(trip.getId(), new ArrayList());
                            }
                            if (firstNonRevEventRecord != null) {
                                NonRevenueStopData firstNonRevenueStopData = new NonRevenueStopData();
                                firstNonRevenueStopData.setNonRevenueStopOrder(NonRevenueStopOrder.FIRST);
                                firstNonRevenueStopData.setScheduleTime(firstNonRevEventRecord.getTime());
                                stopId = this.support.getStopIdForLocation(firstNonRevEventRecord.getLocation());
                                stopAgencyAndId = new AgencyAndId(agencyId, stopId);
                                geographyRecord = this.geographyRecordsByBoxId.get(stopAgencyAndId);
                                c = new Coordinate((double)geographyRecord.getLongitude(), (double)geographyRecord.getLatitude());
                                firstNonRevenueStopData.setLocation(c);
                                this.nonRevenueStopDataByTripId.get(trip.getId()).add(firstNonRevenueStopData);
                            }
                            if (lastNonRevEventRecord == null) continue;
                            NonRevenueStopData lastNonRevenueStopData = new NonRevenueStopData();
                            lastNonRevenueStopData.setNonRevenueStopOrder(NonRevenueStopOrder.LAST);
                            lastNonRevenueStopData.setScheduleTime(lastNonRevEventRecord.getTime());
                            stopId = this.support.getStopIdForLocation(lastNonRevEventRecord.getLocation());
                            stopAgencyAndId = new AgencyAndId(agencyId, stopId);
                            geographyRecord = this.geographyRecordsByBoxId.get(stopAgencyAndId);
                            c = new Coordinate((double)geographyRecord.getLongitude(), (double)geographyRecord.getLatitude());
                            lastNonRevenueStopData.setLocation(c);
                            this.nonRevenueStopDataByTripId.get(trip.getId()).add(lastNonRevenueStopData);
                        }
                        tripRecord = null;
                    }
                    if (!(record instanceof TripRecord)) continue;
                    tripLineNumber = lineNumber;
                    tripRecord = (TripRecord)record;
                    lastNonRevEventRecord = null;
                    firstNonRevEventRecord = null;
                    firstEventRecord = null;
                    eventRecord = null;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addGtfsTrip(File path, int tripLineNumber, TripRecord tripRecord, String runId, String reliefRunId, String nextOperatorRunId, StifTrip rawTrip, String code, TripIdentifier id, List<Trip> filtered, Trip trip) {
        rawTrip.addGtfsTrip(trip);
        int reliefTime = tripRecord.getReliefTime();
        String block = tripRecord.getBlockNumber();
        String depotCode = tripRecord.getDepotCode();
        RawRunData rawRunData = new RawRunData(runId, reliefRunId, nextOperatorRunId, block, depotCode);
        filtered.add(trip);
        this.rawRunDataByTrip.put(trip, rawRunData);
        this.runsForTrip.put(trip.getId(), new RunData(runId, reliefRunId, reliefTime));
        if (rawTrip.type == StifTripType.REVENUE && (code == null || code.length() == 0)) {
            _log.warn("Revenue trip " + rawTrip + " did not have a DSC");
            this.csvLogger.log("trips_with_null_dscs.csv", trip.getId(), id, path, tripLineNumber);
        }
    }

    public Map<Trip, RawRunData> getRawRunDataByTrip() {
        return this.rawRunDataByTrip;
    }

    public Map<AgencyAndId, RunData> getRunsForTrip() {
        return this.runsForTrip;
    }

    public Map<ServiceCode, List<StifTrip>> getRawStifData() {
        return this.rawData;
    }

    public Map<AgencyAndId, List<NonRevenueStopData>> getNonRevenueStopDataByTripId() {
        return this.nonRevenueStopDataByTripId;
    }

    public void setLogger(MultiCSVLogger csvLogger) {
        this.csvLogger = csvLogger;
        csvLogger.header("trips_with_null_dscs.csv", "gtfs_trip_id,stif_trip,stif_filename,stif_trip_record_line_num");
        csvLogger.header("stif_trips_with_no_gtfs_match.csv", "stif_trip,stif_filename,stif_trip_record_line_num");
        csvLogger.header("stif_trip_layers_with_missing_route.csv", "stif_trip,stif_filename,stif_trip_record_line_num,missing_field");
        csvLogger.header("trips_with_duplicate_run_and_start_time.csv", "stif_trip1,stif_filename1,stif_trip_record_line_num1,stif_trip2,stif_filename2,stif_trip_record_line_num2");
    }

    public StifTripLoaderSupport getSupport() {
        return this.support;
    }

    public void setSupport(StifTripLoaderSupport support) {
        this.support = support;
    }

    class DuplicateTripCheckKey {
        String runId;
        Integer startTime;
        ServiceCode serviceCode;

        public DuplicateTripCheckKey(String runId, int startTime, ServiceCode serviceCode) {
            this.runId = runId;
            this.startTime = startTime;
            this.serviceCode = serviceCode;
        }
    }
}

