/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.stif;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.StifTripType;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.TripIdentifier;
import org.onebusaway.transit_data_federation.bundle.tasks.stif.model.ServiceCode;

public class StifTrip
implements Comparable<StifTrip>,
Serializable {
    private static final long serialVersionUID = 1L;
    public String nextRun;
    public String runId;
    public String reliefRunId;
    public String blockId;
    public ServiceCode serviceCode;
    public String firstStop;
    public String lastStop;
    public int firstStopTime;
    public int lastStopTime;
    public int listedLastStopTime;
    public int listedFirstStopTime;
    public int recoveryTime;
    public StifTripType type;
    private ArrayList<Trip> gtfsTrips;
    public boolean firstTripInSequence;
    public boolean lastTripInSequence;
    private String dsc;
    public String signCodeRoute;
    public File path;
    public int lineNumber;
    public TripIdentifier id;
    public String depot;
    public String nextTripOperatorDepot;
    public String agencyId;

    public StifTrip(String runId, String reliefRunId, String nextRun, StifTripType type, String dsc) {
        this.runId = runId;
        this.reliefRunId = reliefRunId;
        this.nextRun = nextRun;
        this.type = type;
        this.dsc = dsc;
    }

    public StifTrip(int firstStopTime) {
        this.firstStopTime = firstStopTime;
    }

    @Override
    public int compareTo(StifTrip o) {
        return this.firstStopTime - o.firstStopTime;
    }

    public void addGtfsTrip(Trip trip) {
        if (this.gtfsTrips == null) {
            this.gtfsTrips = new ArrayList();
        }
        this.gtfsTrips.add(trip);
    }

    public List<Trip> getGtfsTrips() {
        if (this.gtfsTrips == null) {
            return Collections.emptyList();
        }
        return this.gtfsTrips;
    }

    public String getDsc() {
        return this.dsc;
    }

    public String getSignCodeRoute() {
        return this.signCodeRoute;
    }

    public String toString() {
        return "Trip on run (" + this.runId + ") at " + this.firstStopTime + " with dsc '" + this.dsc + "'";
    }

    public String getRunIdWithDepot() {
        if (this.runId != null && this.runId.contains("-") && this.runId.startsWith("MISC")) {
            String[] runParts = this.runId.split("-");
            return runParts[0] + "-" + this.depot + "-" + runParts[1];
        }
        return this.runId + "-" + this.depot;
    }

    public String getNextRunIdWithDepot() {
        if (this.nextRun != null && this.nextRun.contains("-") && this.nextRun.startsWith("MISC")) {
            String[] runParts = this.nextRun.split("-");
            return runParts[0] + "-" + this.nextTripOperatorDepot + "-" + runParts[1];
        }
        return this.nextRun + "-" + this.nextTripOperatorDepot;
    }
}

