/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks.history;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.collections.Range;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.AgencyAndIdInstance;
import org.onebusaway.transit_data_federation.bundle.tasks.history.BlockLocationArchiveSource;
import org.onebusaway.transit_data_federation.impl.realtime.history.BlockLocationArchiveRecord;
import org.onebusaway.transit_data_federation.impl.realtime.history.ScheduleDeviationHistory;
import org.onebusaway.transit_data_federation.services.realtime.ScheduleDeviationHistoryDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.utility.InterpolationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BlockLocationHistoryTask
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(BlockLocationHistoryTask.class);
    private TransitGraphDao _transitGraphDao;
    private ScheduleDeviationHistoryDao _scheduleDeviationHistoryDao;
    private BlockLocationArchiveSource _source;
    private int _sampleTimeStep = 300;
    private int _minSampleSize = 10;
    private double _outlierRatio = 2.0;
    private AgencyAndId _skipToTrip = null;

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setScheduleDeviationHistoryDao(ScheduleDeviationHistoryDao scheduleDeviationHistoryDao) {
        this._scheduleDeviationHistoryDao = scheduleDeviationHistoryDao;
    }

    public void setSource(BlockLocationArchiveSource source) {
        this._source = source;
    }

    public void setSampleStepSize(int sampleTimeStep) {
        this._sampleTimeStep = sampleTimeStep;
    }

    public void seMinSampleSize(int minSampleSize) {
        this._minSampleSize = minSampleSize;
    }

    public void setOutlierRatio(double outlierRatio) {
        this._outlierRatio = outlierRatio;
    }

    public void setSkipToTrip(String tripId) {
        this._skipToTrip = AgencyAndIdLibrary.convertFromString((String)tripId);
    }

    @Override
    public void run() {
        if (this._source == null) {
            _log.info("No BlockLocationHistoryTask data source specified.  Skipping this optional task");
        }
        int tripIndex = 0;
        List allTrips = this._transitGraphDao.getAllTrips();
        boolean skipTo = this._skipToTrip != null;
        for (TripEntry trip : allTrips) {
            if (tripIndex % 20 == 0) {
                _log.info("tripsProcessed=" + tripIndex);
            }
            ++tripIndex;
            if (this._skipToTrip != null && trip.getId().equals((Object)this._skipToTrip)) {
                skipTo = false;
                continue;
            }
            if (skipTo) continue;
            try {
                this.processTrip(trip);
            }
            catch (Throwable ex) {
                _log.warn("error processing trip " + trip.getId(), ex);
            }
        }
    }

    private void processTrip(TripEntry trip) {
        List<BlockLocationArchiveRecord> records = this._source.getRecordsForTrip(trip.getId());
        Map<AgencyAndId, BlockLocationArchiveRecordMap> recordsByTrip = this.loadRecords(records);
        ArrayList<ScheduleDeviationHistory> histories = new ArrayList<ScheduleDeviationHistory>();
        for (Map.Entry<AgencyAndId, BlockLocationArchiveRecordMap> entry : recordsByTrip.entrySet()) {
            AgencyAndId tripId = entry.getKey();
            BlockLocationArchiveRecordMap recordsByInstance = entry.getValue();
            if (recordsByInstance.size() < this._minSampleSize) continue;
            ScheduleDeviationHistory history = this.constructHistory(tripId, recordsByInstance);
            histories.add(history);
        }
        if (!histories.isEmpty()) {
            this._scheduleDeviationHistoryDao.saveScheduleDeviationHistory(histories);
        }
    }

    private Map<AgencyAndId, BlockLocationArchiveRecordMap> loadRecords(List<BlockLocationArchiveRecord> records) {
        FactoryMap recordsByTrip = new FactoryMap((Object)new BlockLocationArchiveRecordMap());
        for (BlockLocationArchiveRecord record : records) {
            AgencyAndId tripId = record.getTripId();
            AgencyAndIdInstance instance = new AgencyAndIdInstance(tripId, record.getServiceDate());
            ((List)((BlockLocationArchiveRecordMap)((Object)recordsByTrip.get(record.getTripId()))).get(instance)).add(record);
        }
        return recordsByTrip;
    }

    private ScheduleDeviationHistory constructHistory(AgencyAndId tripId, BlockLocationArchiveRecordMap recordsByInstance) {
        ArrayList<SortedMap<Integer, Double>> traces = new ArrayList<SortedMap<Integer, Double>>();
        Range tRange = new Range();
        this.sortAndArrangeTraces(recordsByInstance, traces, tRange);
        int step = this.computeSamplingStep(traces);
        int from = (int)(Math.ceil(tRange.getMin() / (double)step) * (double)step);
        int to = (int)(Math.floor(tRange.getMax() / (double)step) * (double)step);
        TreeMap<Integer, Double> mus = new TreeMap<Integer, Double>();
        TreeMap<Integer, Double> sigmas = new TreeMap<Integer, Double>();
        this.computeMeanAndStandardDeviationForTraces(traces, from, to, step, mus, sigmas);
        this.removeOutlierTraces(traces, mus, sigmas);
        int numOfTraces = traces.size();
        DoubleArrayList scheduleTimes = new DoubleArrayList();
        ArrayList<DoubleArrayList> scheduleDeviations = new ArrayList<DoubleArrayList>();
        for (int i = 0; i < numOfTraces; ++i) {
            scheduleDeviations.add(new DoubleArrayList());
        }
        for (int t = from; t <= to; t += step) {
            double sigma;
            double mu;
            int goodValueCount;
            DoubleArrayList rawValues = new DoubleArrayList();
            DoubleArrayList values = new DoubleArrayList();
            for (SortedMap sortedMap : traces) {
                if (t < (Integer)sortedMap.firstKey() || t > (Integer)sortedMap.lastKey()) {
                    rawValues.add(Double.NaN);
                    continue;
                }
                double schedDev = InterpolationLibrary.interpolate((SortedMap)sortedMap, (Number)t);
                values.add(schedDev);
                rawValues.add(schedDev);
            }
            if (values.size() < Math.max(this._minSampleSize, 2) || (goodValueCount = this.pruneOutlierValues(rawValues, mu = Descriptive.mean((DoubleArrayList)values), sigma = Descriptive.sampleStandardDeviation((int)values.size(), (double)Descriptive.sampleVariance((DoubleArrayList)values, (double)mu)))) < this._minSampleSize) continue;
            scheduleTimes.add((double)t);
            for (int traceIndex = 0; traceIndex < traces.size(); ++traceIndex) {
                ((DoubleArrayList)scheduleDeviations.get(traceIndex)).add(rawValues.get(traceIndex));
            }
        }
        scheduleTimes.trimToSize();
        double[] scheduleTimesArray = scheduleTimes.elements();
        double[][] scheduleDeviationsArrays = new double[numOfTraces][];
        for (int traceIndex = 0; traceIndex < numOfTraces; ++traceIndex) {
            DoubleArrayList list = (DoubleArrayList)scheduleDeviations.get(traceIndex);
            list.trimToSize();
            scheduleDeviationsArrays[traceIndex] = list.elements();
        }
        return new ScheduleDeviationHistory(tripId, scheduleTimesArray, (double[][])scheduleDeviationsArrays);
    }

    private void sortAndArrangeTraces(BlockLocationArchiveRecordMap recordsByInstance, List<SortedMap<Integer, Double>> maps, Range tRange) {
        for (List records : recordsByInstance.values()) {
            TreeMap<Integer, Double> m = new TreeMap<Integer, Double>();
            for (BlockLocationArchiveRecord record : records) {
                int effectiveScheduleTime = (int)((double)((record.getTime() - record.getServiceDate()) / 1000L) - record.getScheduleDeviation());
                m.put(effectiveScheduleTime, record.getScheduleDeviation());
                tRange.addValue((double)effectiveScheduleTime);
            }
            maps.add(m);
        }
    }

    private int computeSamplingStep(List<SortedMap<Integer, Double>> traces) {
        int minStep = Integer.MAX_VALUE;
        for (SortedMap<Integer, Double> m : traces) {
            int step;
            if (m.size() < 5 || (step = (m.lastKey() - m.firstKey()) / m.size()) == 0) continue;
            minStep = Math.min(step, minStep);
        }
        if (minStep == Integer.MAX_VALUE || minStep == 0) {
            return this._sampleTimeStep;
        }
        return (int)(Math.ceil((double)minStep / 60.0) * 60.0);
    }

    private void computeMeanAndStandardDeviationForTraces(List<SortedMap<Integer, Double>> traces, int from, int to, int step, SortedMap<Integer, Double> mus, SortedMap<Integer, Double> sigmas) {
        for (int x = from; x <= to; x += step) {
            DoubleArrayList values = new DoubleArrayList();
            for (SortedMap<Integer, Double> m : traces) {
                if (x < m.firstKey() || x > m.lastKey()) continue;
                double schedDev = InterpolationLibrary.interpolate(m, (Number)x);
                values.add(schedDev);
            }
            if (values.size() < 2) continue;
            double mu = Descriptive.mean((DoubleArrayList)values);
            double sigma = Descriptive.sampleStandardDeviation((int)values.size(), (double)Descriptive.sampleVariance((DoubleArrayList)values, (double)mu));
            mus.put(x, mu);
            sigmas.put(x, sigma);
        }
    }

    private void removeOutlierTraces(List<SortedMap<Integer, Double>> maps, SortedMap<Integer, Double> mus, SortedMap<Integer, Double> sigmas) {
        Iterator<SortedMap<Integer, Double>> it = maps.iterator();
        while (it.hasNext()) {
            SortedMap<Integer, Double> m = it.next();
            if (!this.isTraceAnOutlier(m, mus, sigmas)) continue;
            it.remove();
        }
    }

    private boolean isTraceAnOutlier(SortedMap<Integer, Double> m, SortedMap<Integer, Double> mus, SortedMap<Integer, Double> sigmas) {
        double outliers = 0.0;
        for (Map.Entry<Integer, Double> entry : m.entrySet()) {
            int t = entry.getKey();
            double value = entry.getValue();
            double mu = InterpolationLibrary.interpolate(mus, (Number)t);
            double sigma = InterpolationLibrary.interpolate(sigmas, (Number)t);
            if (!(Math.abs(value - mu) > this._outlierRatio * sigma)) continue;
            outliers += 1.0;
        }
        return outliers / (double)m.size() > 0.5;
    }

    private int pruneOutlierValues(DoubleArrayList rawValues, double mu, double sigma) {
        int goodValueCount = 0;
        for (int i = 0; i < rawValues.size(); ++i) {
            double value = rawValues.get(i);
            if (Double.isNaN(value)) continue;
            if (Math.abs(value - mu) > this._outlierRatio * sigma) {
                rawValues.set(i, Double.NaN);
                continue;
            }
            ++goodValueCount;
        }
        return goodValueCount;
    }

    public static class BlockLocationArchiveRecordMap
    extends FactoryMap<AgencyAndIdInstance, List<BlockLocationArchiveRecord>> {
        private static final long serialVersionUID = 1L;

        public BlockLocationArchiveRecordMap() {
            super(new ArrayList());
        }
    }
}

