/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.transit_data_federation.bundle.tasks.AbstractStopTask;
import org.onebusaway.util.AgencyAndIdLibrary;

public class StopVerificationTask
extends AbstractStopTask
implements Runnable {
    @Override
    protected void insertHeader() {
        this._logger.header("stop_verification.csv", "root_stop_id,pass?,missing_stop_id,unexpected_stop_ids");
    }

    @Override
    protected void verifyStops(String rootStopId, List<String> consolidatedStops) {
        AgencyAndId agencyAndId = AgencyAndIdLibrary.convertFromString((String)rootStopId);
        Stop expectedStop = this._dao.getStopForId(agencyAndId);
        boolean pass = expectedStop != null;
        String missingStopId = pass ? "" : rootStopId;
        Object unexpectedStopIds = "";
        for (String consolidatedStop : consolidatedStops) {
            Stop unexpectedStop = this._dao.getStopForId(AgencyAndIdLibrary.convertFromString((String)consolidatedStop));
            if (unexpectedStop == null) continue;
            pass = false;
            unexpectedStopIds = (String)unexpectedStopIds + consolidatedStop + " ";
        }
        if (!pass) {
            this._logger.log("stop_verification.csv", rootStopId, String.valueOf(pass), missingStopId, unexpectedStopIds);
        }
    }
}

