/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data_federation.model.ShapePoints;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShapePointHelper {
    private GtfsRelationalDao _gtfsDao;
    private Map<AgencyAndId, ShapePoints> _cache = new HashMap<AgencyAndId, ShapePoints>();

    @Autowired
    public void setGtfsRelationalDao(GtfsRelationalDao gtfsDao) {
        this._gtfsDao = gtfsDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShapePoints getShapePointsForShapeId(AgencyAndId shapeId) {
        Map<AgencyAndId, ShapePoints> map = this._cache;
        synchronized (map) {
            ShapePoints shapePoints = this._cache.get(shapeId);
            if (shapePoints == null) {
                shapePoints = this.getShapePointsForShapeIdNonCached(shapeId);
                this._cache.put(shapeId, shapePoints);
            }
            return shapePoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShapePoints getShapePointsForShapeIdNonCached(AgencyAndId shapeId) {
        List<ShapePoint> shapePoints = null;
        GtfsRelationalDao gtfsRelationalDao = this._gtfsDao;
        synchronized (gtfsRelationalDao) {
            shapePoints = this._gtfsDao.getShapePointsForShapeId(shapeId);
        }
        shapePoints = this.deduplicateShapePoints(shapePoints);
        if (shapePoints.isEmpty()) {
            return null;
        }
        int n = shapePoints.size();
        double[] lat = new double[n];
        double[] lon = new double[n];
        double[] distTraveled = new double[n];
        int i = 0;
        for (ShapePoint shapePoint : shapePoints) {
            lat[i] = shapePoint.getLat();
            lon[i] = shapePoint.getLon();
            ++i;
        }
        ShapePoints result = new ShapePoints();
        result.setShapeId(shapeId);
        result.setLats(lat);
        result.setLons(lon);
        result.setDistTraveled(distTraveled);
        result.ensureDistTraveled();
        return result;
    }

    private List<ShapePoint> deduplicateShapePoints(List<ShapePoint> shapePoints) {
        ArrayList<ShapePoint> deduplicated = new ArrayList<ShapePoint>();
        ShapePoint prev = null;
        for (ShapePoint shapePoint : shapePoints) {
            if (prev == null || prev.getLat() != shapePoint.getLat() || prev.getLon() != shapePoint.getLon()) {
                deduplicated.add(shapePoint);
            }
            prev = shapePoint;
        }
        return deduplicated;
    }
}

