/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.container.refresh.RefreshService;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.bundle.tasks.ShapePointHelper;
import org.onebusaway.transit_data_federation.model.ShapePoints;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ShapeGeospatialIndexTask
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(ShapeGeospatialIndexTask.class);
    private static double MIN_LAT_LON = -360.0;
    private static double MAX_LAT_LON = 360.0;
    private TransitGraphDao _transitGraphDao;
    private ShapePointHelper _shapePointHelper;
    private FederatedTransitDataBundle _bundle;
    private RefreshService _refreshService;
    private double _gridSize = 500.0;

    ShapeGeospatialIndexTask() {
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setShapePointHelper(ShapePointHelper shapePointHelper) {
        this._shapePointHelper = shapePointHelper;
    }

    @Autowired
    public void setRefreshService(RefreshService refreshService) {
        this._refreshService = refreshService;
    }

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    public void setGridSize(double gridSize) {
        this._gridSize = gridSize;
    }

    @Override
    public void run() {
        try {
            Map<CoordinateBounds, List<AgencyAndId>> shapeIdsByGridCell = this.buildShapeSpatialIndex();
            File path = this._bundle.getShapeGeospatialIndexDataPath();
            ObjectSerializationLibrary.writeObject((File)path, shapeIdsByGridCell);
            this._refreshService.refresh("shapeGeospatialIndex");
        }
        catch (Exception ex) {
            throw new IllegalStateException("error creating shape geospatial index data", ex);
        }
    }

    private Set<AgencyAndId> getAllShapeIds() {
        HashSet<AgencyAndId> shapeIds = new HashSet<AgencyAndId>();
        for (TripEntry trip : this._transitGraphDao.getAllTrips()) {
            AgencyAndId shapeId = trip.getShapeId();
            if (shapeId == null) continue;
            shapeIds.add(shapeId);
        }
        return shapeIds;
    }

    private Map<CoordinateBounds, List<AgencyAndId>> buildShapeSpatialIndex() {
        FactoryMap shapeIdsByGridCellCorner = new FactoryMap(new HashSet());
        CoordinateBounds fullBounds = new CoordinateBounds();
        for (StopEntry stop : this._transitGraphDao.getAllStops()) {
            if (stop.getStopLat() > MIN_LAT_LON && stop.getStopLon() > MIN_LAT_LON && stop.getStopLat() < MAX_LAT_LON && stop.getStopLon() < MAX_LAT_LON) {
                fullBounds.addPoint(stop.getStopLat(), stop.getStopLon());
                continue;
            }
            _log.error("rejecting stop " + stop + " for invalid (lat,lon)=" + stop.getStopLat() + ", " + stop.getStopLon());
        }
        if (fullBounds.isEmpty()) {
            return Collections.emptyMap();
        }
        double centerLat = (fullBounds.getMinLat() + fullBounds.getMaxLat()) / 2.0;
        double centerLon = (fullBounds.getMinLon() + fullBounds.getMaxLon()) / 2.0;
        CoordinateBounds gridCellExample = SphericalGeometryLibrary.bounds((double)centerLat, (double)centerLon, (double)(this._gridSize / 2.0));
        double latStep = gridCellExample.getMaxLat() - gridCellExample.getMinLat();
        double lonStep = gridCellExample.getMaxLon() - gridCellExample.getMinLon();
        _log.info("generating shape point geospatial index...");
        Set<AgencyAndId> allShapeIds = this.getAllShapeIds();
        for (AgencyAndId shapeId : allShapeIds) {
            ShapePoints shapePoints = this._shapePointHelper.getShapePointsForShapeId(shapeId);
            for (int i = 0; i < shapePoints.getSize(); ++i) {
                double lat = shapePoints.getLatForIndex(i);
                double lon = shapePoints.getLonForIndex(i);
                this.addGridCellForShapePoint((Map<CoordinatePoint, Set<AgencyAndId>>)shapeIdsByGridCellCorner, lat, lon, latStep, lonStep, shapeId);
                if (i <= 0) continue;
                double prevLat = shapePoints.getLatForIndex(i - 1);
                double prevLon = shapePoints.getLonForIndex(i - 1);
                double totalDistance = SphericalGeometryLibrary.distance((double)prevLat, (double)prevLon, (double)lat, (double)lon);
                for (double d = this._gridSize; d < totalDistance; d += this._gridSize) {
                    double r = d / totalDistance;
                    double latPart = (lat - prevLat) * r + prevLat;
                    double lonPart = (lon - prevLon) * r + prevLon;
                    this.addGridCellForShapePoint((Map<CoordinatePoint, Set<AgencyAndId>>)shapeIdsByGridCellCorner, latPart, lonPart, latStep, lonStep, shapeId);
                }
            }
        }
        _log.info("block shape geospatial nodes: " + shapeIdsByGridCellCorner.size());
        HashMap<CoordinateBounds, List<AgencyAndId>> shapeIdsByGridCell = new HashMap<CoordinateBounds, List<AgencyAndId>>();
        for (Map.Entry entry : shapeIdsByGridCellCorner.entrySet()) {
            CoordinatePoint p = (CoordinatePoint)entry.getKey();
            CoordinateBounds bounds = new CoordinateBounds(p.getLat(), p.getLon(), p.getLat() + latStep, p.getLon() + lonStep);
            ArrayList shapeIds = new ArrayList((Collection)entry.getValue());
            shapeIdsByGridCell.put(bounds, shapeIds);
        }
        return shapeIdsByGridCell;
    }

    private void addGridCellForShapePoint(Map<CoordinatePoint, Set<AgencyAndId>> shapeIdsByGridCellCorner, double lat, double lon, double latStep, double lonStep, AgencyAndId shapeId) {
        CoordinatePoint gridCellCorner = this.getGridCellCornerForPoint(lat, lon, latStep, lonStep);
        shapeIdsByGridCellCorner.get(gridCellCorner).add(shapeId);
    }

    private CoordinatePoint getGridCellCornerForPoint(double lat, double lon, double latStep, double lonStep) {
        double latCorner = Math.floor(lat / latStep) * latStep;
        double lonCorner = Math.floor(lon / lonStep) * lonStep;
        return new CoordinatePoint(latCorner, lonCorner);
    }
}

