/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.util.HashSet;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.onebusaway.exceptions.ServiceException;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.AgencyBean;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PreCacheTask
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(PreCacheTask.class);
    private TransitDataService _service;
    private CacheManager _cacheManager;
    private TransitGraphDao _transitGraphDao;

    @Autowired
    public void setCacheManager(CacheManager cacheManager) {
        this._cacheManager = cacheManager;
    }

    @Autowired
    public void setTransitDataService(TransitDataService service) {
        this._service = service;
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Override
    public void run() {
        for (String cacheName : this._cacheManager.getCacheNames()) {
            Cache cache = this._cacheManager.getCache(cacheName);
            cache.removeAll();
        }
        try {
            List agenciesWithCoverage = this._service.getAgenciesWithCoverage();
            for (AgencyWithCoverageBean agencyWithCoverage : agenciesWithCoverage) {
                AgencyBean agency = agencyWithCoverage.getAgency();
                System.out.println("agency=" + agency.getId());
                ListBean stopIds = this._service.getStopIdsForAgencyId(agency.getId());
                for (String stopId : stopIds.getList()) {
                    System.out.println("  stop=" + stopId);
                    this._service.getStop(stopId);
                }
                ListBean routeIds = this._service.getRouteIdsForAgencyId(agency.getId());
                for (String routeId : routeIds.getList()) {
                    System.out.println("  route=" + routeId);
                    this._service.getStopsForRoute(routeId);
                }
            }
            HashSet<AgencyAndId> shapeIds = new HashSet<AgencyAndId>();
            for (TripEntry trip : this._transitGraphDao.getAllTrips()) {
                AgencyAndId shapeId = trip.getShapeId();
                if (shapeId == null || !shapeId.hasValues()) continue;
                shapeIds.add(shapeId);
            }
            for (AgencyAndId shapeId : shapeIds) {
                System.out.println("shape=" + shapeId);
                this._service.getShapeForId(AgencyAndIdLibrary.convertToString((AgencyAndId)shapeId));
            }
        }
        catch (ServiceException ex) {
            _log.error("service exception", (Throwable)ex);
        }
    }
}

