/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.File;
import java.util.ArrayList;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Ridership;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data_federation.model.bundle.HistoricalRidership;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HistoricalRecordTask
implements Runnable {
    private FederatedTransitDataBundle _bundle;
    private GtfsRelationalDao _gtfsDao;
    private Logger _log = LoggerFactory.getLogger(HistoricalRecordTask.class);

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Autowired
    public void setGtfsDao(GtfsRelationalDao gtfsDao) {
        this._gtfsDao = gtfsDao;
    }

    @Override
    public void run() {
        try {
            this._log.info("gtfsDao has " + this._gtfsDao.getAllRiderships().size() + " records ");
            ArrayList<HistoricalRidership> historicalRiderships = new ArrayList<HistoricalRidership>();
            for (Ridership r : this._gtfsDao.getAllRiderships()) {
                historicalRiderships.add(this.toHistoricalRidership(r));
            }
            this._log.info("translated " + historicalRiderships.size() + " records ");
            ObjectSerializationLibrary.writeObject((File)this._bundle.getHistoricalRidershipPath(), historicalRiderships);
            this._log.info("wrote " + historicalRiderships.size() + " records to " + this._bundle.getHistoricalRidershipPath());
        }
        catch (Exception ex) {
            this._log.error("fatal exception building HistoricalRecordTask:", (Throwable)ex);
        }
    }

    private HistoricalRidership toHistoricalRidership(Ridership r) {
        HistoricalRidership.Builder hr = HistoricalRidership.builder();
        hr.setStopId(this.findStopId(r.getStopId()));
        hr.setTripId(this.findTripId(r.getTripId()));
        hr.setRouteId(this.findRouteId(r.getRouteId()));
        hr.setCalendarType(HistoricalRidership.CalendarType.WEEKDAY);
        hr.setLoadFactor(r.getAverageLoad());
        this._log.info("created Ridership " + r.getRouteId() + ":" + r.getTripId() + ":" + r.getStopId() + "=" + r.getAverageLoad());
        return hr.create();
    }

    private AgencyAndId findStopId(String rawStopId) {
        return new AgencyAndId("1", rawStopId);
    }

    private AgencyAndId findTripId(String rawTripId) {
        return new AgencyAndId("1", rawTripId);
    }

    private AgencyAndId findRouteId(String rawRouteId) {
        return new AgencyAndId("1", rawRouteId);
    }
}

