/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import com.conveyal.gtfs.model.Statistic;
import com.conveyal.gtfs.service.impl.GtfsStatisticsService;
import java.io.File;
import java.util.Collection;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.transit_data_federation.bundle.tasks.GtfsCsvLogger;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GtfsStatisticsTask
implements Runnable {
    private Logger _log = LoggerFactory.getLogger(GtfsStatisticsTask.class);
    private static final String ALL_AGENCIES = "TOTAL";
    private GtfsRelationalDaoImpl _dao;
    private FederatedTransitDataBundle _bundle;

    @Autowired
    public void setGtfsDao(GtfsRelationalDaoImpl dao) {
        this._dao = dao;
    }

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Override
    public void run() {
        File basePath = this._bundle.getPath();
        this._log.info("Starting GTFS stats to basePath=" + basePath);
        GtfsStatisticsService service = new GtfsStatisticsService(this._dao);
        GtfsCsvLogger csvLogger = new GtfsCsvLogger();
        csvLogger.setBasePath(basePath);
        csvLogger.open();
        csvLogger.header();
        Collection agencies = service.getAllAgencies();
        for (Agency agency : agencies) {
            this._log.info("processing stats for agency: " + agency.getId() + " (" + agency.getName() + ")");
            csvLogger.logStat(agency.getId(), service.getStatistic(agency.getId()));
        }
        Statistic all = new Statistic();
        Agency allAgency = new Agency();
        allAgency.setId(ALL_AGENCIES);
        all.setAgencyId(ALL_AGENCIES);
        all.setRouteCount(service.getRouteCount());
        all.setTripCount(service.getTripCount());
        all.setStopCount(service.getStopCount());
        all.setStopTimeCount(service.getStopTimesCount());
        all.setCalendarStartDate(service.getCalendarServiceRangeStart());
        all.setCalendarEndDate(service.getCalendarServiceRangeEnd());
        csvLogger.logStat(allAgency.getId(), all);
        this._log.info("cleaning up");
        csvLogger.close();
        this._log.info("exiting");
    }
}

