/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.Counter;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.gtfs.impl.GenericMutableDaoWrapper;
import org.onebusaway.gtfs.impl.GtfsDaoImpl;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.onebusaway.transit_data_federation.bundle.services.EntityReplacementLogger;
import org.onebusaway.transit_data_federation.bundle.services.EntityReplacementStrategy;
import org.onebusaway.transit_data_federation.bundle.tasks.EntityReplacementStrategyImpl;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsMultiReaderImpl
implements Runnable {
    private final Logger _log = LoggerFactory.getLogger(GtfsMultiReaderImpl.class);
    private List<GtfsReader> _readers = new ArrayList<GtfsReader>();
    private GenericMutableDao _store;
    private GtfsDaoImpl _rejectionStore = new GtfsDaoImpl();
    private EntityReplacementStrategy _entityReplacementStrategy = new EntityReplacementStrategyImpl();
    private EntityReplacementLogger _entityLogger = null;

    public void setEntityReplacementLogger(EntityReplacementLogger logger) {
        this._entityLogger = logger;
    }

    public void setStore(GenericMutableDao store) {
        this._store = store;
    }

    public void setEntityReplacementStrategy(EntityReplacementStrategy strategy) {
        this._entityReplacementStrategy = strategy;
    }

    public void addGtfsReader(GtfsReader reader) {
        this._readers.add(reader);
    }

    public void addGtfsReaderFromInputLocation(File inputLocation) throws IOException {
        GtfsReader reader = new GtfsReader();
        reader.setInputLocation(inputLocation);
        this.addGtfsReader(reader);
    }

    @Override
    public void run() {
        if (this._readers.isEmpty()) {
            return;
        }
        if (this._entityLogger != null) {
            this._entityReplacementStrategy.setEntityReplacementLogger(this._entityLogger);
            this._entityLogger.setStore(this._store);
            this._entityLogger.setRejectionStore((GenericMutableDao)this._rejectionStore);
        }
        try {
            StoreImpl store = new StoreImpl(this._store);
            for (GtfsReader reader : this._readers) {
                reader.setEntityStore((GenericMutableDao)store);
                reader.addEntityHandler((EntityHandler)new EntityCounter());
            }
            store.open();
            ArrayList agencies = new ArrayList();
            List entityClasses = this._readers.get(0).getEntityClasses();
            for (Class entityClass : entityClasses) {
                this._log.info("reading entities: " + entityClass.getName());
                for (GtfsReader reader : this._readers) {
                    if (entityClass.equals(Agency.class)) {
                        reader.setAgencies(agencies);
                    }
                    reader.readEntities(entityClass);
                    if (entityClass.equals(Agency.class)) {
                        agencies = new ArrayList(reader.getAgencies());
                    }
                    store.flush();
                }
            }
            store.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static class EntityCounter
    implements EntityHandler {
        private Counter<String> _counter = new Counter();
        private Map<String, Long> _startTime = new HashMap<String, Long>();
        private int logInterval = 1000;

        private EntityCounter() {
        }

        public void handleEntity(Object bean) {
            String name = bean.getClass().getName();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(index + 1);
            }
            this.increment(name);
        }

        private void increment(String key) {
            this._counter.increment((Object)key);
            int c = this._counter.getCount((Object)key);
            if (c % this.logInterval == 0) {
                if (c == this.logInterval * 10) {
                    this.logInterval *= 10;
                    System.out.println("now logging every " + this.logInterval);
                }
                if (c % 1000 == 0) {
                    double ellapsedTime = (double)(SystemTime.currentTimeMillis() - this.getStartTimeForKey(key)) / 1000.0;
                    System.out.println(key + " = " + c + " rate=" + (long)((double)c / ellapsedTime));
                }
            }
        }

        private long getStartTimeForKey(String key) {
            Long value = this._startTime.get(key);
            if (value == null) {
                value = SystemTime.currentTimeMillis();
                this._startTime.put(key, value);
            }
            return value;
        }
    }

    private class StoreImpl
    extends GenericMutableDaoWrapper {
        public StoreImpl(GenericMutableDao source) {
            super(source);
        }

        public <T> T getEntityForId(Class<T> type, Serializable id) {
            Serializable replacementId = GtfsMultiReaderImpl.this._entityReplacementStrategy.getReplacementEntityId(type, id);
            if (replacementId != null) {
                Object entity = super.getEntityForId(type, replacementId);
                if (entity != null) {
                    GtfsMultiReaderImpl.this._entityReplacementStrategy.logReplacement(type, id, replacementId, super.getEntityForId(type, id), entity);
                    return (T)entity;
                }
                GtfsMultiReaderImpl.this._log.warn("error replacing entity: type=" + type.getName() + " fromId=" + id + " toId=" + replacementId + " - replacement not found");
            }
            return (T)super.getEntityForId(type, id);
        }

        public void saveEntity(Object entity) {
            IdentityBean bean;
            Serializable id;
            Class<?> entityType = entity.getClass();
            if (entity instanceof IdentityBean && GtfsMultiReaderImpl.this._entityReplacementStrategy.hasReplacementEntities(entityType) && GtfsMultiReaderImpl.this._entityReplacementStrategy.hasReplacementEntity(entityType, id = (bean = (IdentityBean)entity).getId())) {
                GtfsMultiReaderImpl.this._rejectionStore.saveEntity(entity);
                return;
            }
            super.saveEntity(entity);
        }
    }
}

