/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.onebusaway.container.refresh.RefreshService;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.model.narrative.StopNarrative;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GenerateStopSearchIndexTask
implements Runnable {
    private TransitGraphDao _transitGraphDao;
    private NarrativeService _narrativeService;
    private FederatedTransitDataBundle _bundle;
    private RefreshService _refreshService;

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setNarrativeService(NarrativeService narrativeService) {
        this._narrativeService = narrativeService;
    }

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Autowired
    public void setRefreshService(RefreshService refreshService) {
        this._refreshService = refreshService;
    }

    @Override
    public void run() {
        try {
            this.buildIndex();
        }
        catch (Exception ex) {
            throw new IllegalStateException("error building stop search index", ex);
        }
    }

    private void buildIndex() throws IOException, ParseException {
        LimitTokenCountAnalyzer limitTokenCountAnalyzer = new LimitTokenCountAnalyzer((Analyzer)new StandardAnalyzer(), 10000);
        FSDirectory index = FSDirectory.open((Path)this._bundle.getStopSearchIndexPath().toPath());
        IndexWriterConfig config = new IndexWriterConfig((Analyzer)limitTokenCountAnalyzer);
        IndexWriter writer = new IndexWriter((Directory)index, config);
        for (StopEntry stopEntry : this._transitGraphDao.getAllStops()) {
            StopNarrative narrative = this._narrativeService.getStopForId(stopEntry.getId());
            Document document = this.getStopAsDocument(stopEntry, narrative);
            writer.addDocument((Iterable)document);
        }
        writer.close();
        this._refreshService.refresh("stopSearchData");
    }

    private Document getStopAsDocument(StopEntry stopEntry, StopNarrative narrative) {
        Document document = new Document();
        AgencyAndId id = stopEntry.getId();
        document.add((IndexableField)new StringField("agencyId", id.getAgencyId(), Field.Store.YES));
        document.add((IndexableField)new TextField("stopId", id.getId(), Field.Store.YES));
        if (narrative.getCode() != null && narrative.getCode().length() > 0) {
            document.add((IndexableField)new StringField("code", narrative.getCode(), Field.Store.NO));
        } else {
            document.add((IndexableField)new TextField("code", stopEntry.getId().getId(), Field.Store.NO));
        }
        if (narrative.getName() != null && narrative.getName().length() > 0) {
            document.add((IndexableField)new TextField("name", narrative.getName(), Field.Store.YES));
        }
        return document;
    }
}

