/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.onebusaway.container.refresh.RefreshService;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.model.narrative.RouteCollectionNarrative;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteCollectionEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class GenerateRouteCollectionSearchIndexTask
implements Runnable {
    public static final String[] ENGLISH_STOP_WORDS = new String[]{"an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};
    private TransitGraphDao _transitGraphDao;
    private NarrativeService _narrativeService;
    private FederatedTransitDataBundle _bundle;
    private RefreshService _refreshService;

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setNarrativeService(NarrativeService narrativeService) {
        this._narrativeService = narrativeService;
    }

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Autowired
    public void setRefreshService(RefreshService refreshService) {
        this._refreshService = refreshService;
    }

    @Override
    @Transactional
    public void run() {
        try {
            this.buildIndex();
        }
        catch (Exception ex) {
            throw new IllegalStateException("error building route search index", ex);
        }
    }

    private void buildIndex() throws IOException, ParseException {
        LimitTokenCountAnalyzer limitTokenCountAnalyzer = new LimitTokenCountAnalyzer((Analyzer)new StandardAnalyzer(new CharArraySet(Arrays.asList(ENGLISH_STOP_WORDS), true)), 10000);
        FSDirectory index = FSDirectory.open((Path)this._bundle.getRouteSearchIndexPath().toPath());
        IndexWriterConfig config = new IndexWriterConfig((Analyzer)limitTokenCountAnalyzer);
        IndexWriter writer = new IndexWriter((Directory)index, config);
        for (RouteCollectionEntry routeCollection : this._transitGraphDao.getAllRouteCollections()) {
            RouteCollectionNarrative narrative = this._narrativeService.getRouteCollectionForId(routeCollection.getId());
            Document document = this.getRouteCollectionAsDocument(routeCollection, narrative);
            writer.addDocument((Iterable)document);
        }
        writer.close();
        this._refreshService.refresh("routeCollectionSearchData");
    }

    private Document getRouteCollectionAsDocument(RouteCollectionEntry routeCollection, RouteCollectionNarrative narrative) {
        AgencyAndId routeCollectionId = routeCollection.getId();
        Document document = new Document();
        document.add((IndexableField)new StringField("routeCollectionAgencyId", routeCollectionId.getAgencyId(), Field.Store.YES));
        document.add((IndexableField)new StringField("routeCollectionId", routeCollectionId.getId(), Field.Store.YES));
        if (GenerateRouteCollectionSearchIndexTask.isValue(narrative.getShortName())) {
            document.add((IndexableField)new TextField("shortName", narrative.getShortName(), Field.Store.YES));
        }
        if (GenerateRouteCollectionSearchIndexTask.isValue(narrative.getLongName())) {
            document.add((IndexableField)new TextField("longName", narrative.getLongName(), Field.Store.NO));
        }
        if (GenerateRouteCollectionSearchIndexTask.isValue(narrative.getDescription())) {
            document.add((IndexableField)new TextField("description", narrative.getDescription(), Field.Store.NO));
        }
        return document;
    }

    private static boolean isValue(String value) {
        return value != null && value.length() > 0;
    }
}

