/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.onebusaway.gtfs_transformer.impl.SphericalGeometryLibrary;
import org.onebusaway.transit_data_federation.bundle.services.EntityReplacementLogger;
import org.onebusaway.transit_data_federation.bundle.tasks.MultiCSVLogger;
import org.onebusaway.transit_data_federation.bundle.tasks.MultiCSVLoggerSummarizeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityReplacementLoggerImpl
implements EntityReplacementLogger {
    private static Logger _log = LoggerFactory.getLogger(EntityReplacementLoggerImpl.class);
    private MultiCSVLogger _csvLogger = null;
    private GenericMutableDao _dao = null;
    private GenericMutableDao _rejectionDao = null;
    private Map<Serializable, EntityStore> _replacements = new HashMap<Serializable, EntityStore>();

    @Override
    public void setMultiCSVLogger(MultiCSVLogger logger) {
        this._csvLogger = logger;
    }

    @Override
    public void setStore(GenericMutableDao dao) {
        this._dao = dao;
    }

    @Override
    public void setRejectionStore(GenericMutableDao dao) {
        this._rejectionDao = dao;
    }

    @Override
    public MultiCSVLoggerSummarizeListener getListener() {
        return new SummaryListener(this);
    }

    @Override
    public <T> T log(Class<T> type, Serializable id, Serializable replacementId, T originalEntity, T replacementEntity) {
        if ("Stop".equals(type.getSimpleName())) {
            Stop original = (Stop)originalEntity;
            Stop replacement = (Stop)replacementEntity;
            Double originLat = null;
            Double originLon = null;
            Double replacementLat = null;
            Double replacementLon = null;
            if (original != null) {
                originLat = original.getLat();
                originLon = original.getLon();
            }
            if (replacement != null) {
                replacementLat = replacement.getLat();
                replacementLon = replacement.getLon();
            }
            this.updateStore(id, replacementId, originLat, originLon, replacementLat, replacementLon);
        }
        return replacementEntity;
    }

    private void updateStore(Serializable id, Serializable replacementId, Double originLat, Double originLon, Double replacementLat, Double replacementLon) {
        String key = this.hash(id, replacementId);
        EntityStore store = this._replacements.get(key);
        if (store == null) {
            Stop stop;
            if (originLat == null && this._rejectionDao != null && (stop = (Stop)this._rejectionDao.getEntityForId(Stop.class, id)) != null) {
                originLat = stop.getLat();
                originLon = stop.getLon();
            }
            store = new EntityStore(id, replacementId, originLat, originLon, replacementLat, replacementLon);
            this._replacements.put((Serializable)((Object)key), store);
        } else {
            store.update(originLat, originLon, replacementLat, replacementLon);
        }
    }

    private String hash(Serializable a, Serializable b) {
        return a + ":" + b;
    }

    public void log() {
        if (!this._csvLogger.hasHeader("gtfs_stop_replacements.csv")) {
            this._csvLogger.header("gtfs_stop_replacements.csv", "orginal_stop_id,replacement_stop_id,original_lat,original_lon,replacement_lat,replacement_lon,distance_in_feet");
            for (Serializable key : this._replacements.keySet()) {
                EntityStore es = this._replacements.get(key);
                this._csvLogger.log("gtfs_stop_replacements.csv", es.getId(), es.getReplacementId(), es.getOriginalLat(), es.getOriginalLon(), es.getReplacmentLat(), es.getReplacmentLon(), es.getDistanceInFeet());
            }
        }
    }

    public static class SummaryListener
    implements MultiCSVLoggerSummarizeListener {
        EntityReplacementLoggerImpl self;

        public SummaryListener(EntityReplacementLoggerImpl self) {
            this.self = self;
        }

        @Override
        public void summarize() {
            this.self.log();
        }
    }

    public static class EntityStore {
        private Serializable originalId;
        private Serializable replacementId;
        private Double originalLat;
        private Double originalLon;
        private Double replacementLat;
        private Double replacementLon;

        public EntityStore(Serializable originalId, Serializable replacementId, Double originalLat, Double originalLon, Double replacementLat, Double replacementLon) {
            this.originalId = originalId;
            this.replacementId = replacementId;
            this.originalLat = originalLat;
            this.originalLon = originalLon;
            this.replacementLat = replacementLat;
            this.replacementLon = replacementLon;
        }

        public void update(Double originalLat, Double originalLon, Double replacementLat, Double replacementLon) {
            if (this.originalLat == null && originalLat != null) {
                this.originalLat = originalLat;
            }
            if (this.originalLon == null && originalLon != null) {
                this.originalLon = originalLon;
            }
            if (this.replacementLat == null && replacementLat != null) {
                this.replacementLat = replacementLat;
            }
            if (this.replacementLon == null && replacementLon != null) {
                this.replacementLon = replacementLon;
            }
        }

        public Serializable getId() {
            return this.originalId;
        }

        public Serializable getReplacementId() {
            return this.replacementId;
        }

        public Double getOriginalLat() {
            return this.originalLat;
        }

        public Double getOriginalLon() {
            return this.originalLon;
        }

        public Double getReplacmentLat() {
            return this.replacementLat;
        }

        public Double getReplacmentLon() {
            return this.replacementLon;
        }

        public Double getDistanceInFeet() {
            if (this.originalLat == null || this.originalLon == null || this.replacementLat == null || this.replacementLon == null) {
                return null;
            }
            return SphericalGeometryLibrary.distanceFaster((double)this.originalLat, (double)this.originalLon, (double)this.replacementLat, (double)this.replacementLon) * 3.28084;
        }
    }
}

