/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.map.HashedMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.RouteShape;
import org.onebusaway.gtfs.model.RouteStop;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data_federation.impl.transit_graph.CanonicalRoutesEntryImpl;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.transit_graph.CanonicalRoutesEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteShapeDirectionKey;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteStopCollectionEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class CanonicalRouteTask
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(CanonicalRouteTask.class);
    @Autowired
    private GtfsRelationalDao _gtfsDao;
    @Autowired
    private FederatedTransitDataBundle _bundle;
    private Map<AgencyAndId, List<RouteStopCollectionEntry>> routeIdToRouteStops = new HashMap<AgencyAndId, List<RouteStopCollectionEntry>>();
    private Map<RouteShapeDirectionKey, String> routeShapeKeyToEncodedShape = new HashMap<RouteShapeDirectionKey, String>();
    private Map<AgencyAndId, Map<String, String>> routeIdToDirectionAndShape = new HashMap<AgencyAndId, Map<String, String>>();

    @Override
    public void run() {
        this.indexRouteStops();
        this.indexRouteShapes();
        _log.info("found {} RouteStops and {} RouteShapes, flushing to bundle", (Object)this.routeIdToRouteStops.size(), (Object)this.routeShapeKeyToEncodedShape.size());
        CanonicalRoutesEntryImpl canonicalRoutes = new CanonicalRoutesEntryImpl();
        canonicalRoutes.setRouteIdToRouteStops(this.routeIdToRouteStops);
        canonicalRoutes.setRouteShapeKeyToEncodedShape(this.routeShapeKeyToEncodedShape);
        canonicalRoutes.setRouteIdToDirectionAndShape(this.routeIdToDirectionAndShape);
        this.writeObject((CanonicalRoutesEntry)canonicalRoutes);
    }

    private void writeObject(CanonicalRoutesEntry canonicalRoutes) {
        try {
            ObjectSerializationLibrary.writeObject((File)this._bundle.getCanonicalRoutePath(), (Object)canonicalRoutes);
        }
        catch (IOException e) {
            _log.error("fatal exception building CanonicalRoutes:", (Object)e, (Object)e);
        }
    }

    private void indexRouteShapes() {
        for (RouteShape routeShape : this._gtfsDao.getAllRouteShapes()) {
            RouteShapeDirectionKey rsde = new RouteShapeDirectionKey();
            try {
                char separator = '_';
                if (routeShape.getRouteId().indexOf(separator) == -1) {
                    separator = ':';
                }
                AgencyAndId agencyAndId = AgencyAndIdLibrary.convertFromString((String)routeShape.getRouteId(), (char)separator);
                rsde.setRouteId(agencyAndId);
            }
            catch (IllegalStateException ise) {
                _log.error("illegal routeId " + routeShape.getRouteId());
                continue;
            }
            if (routeShape.getDirectionId() == null) {
                rsde.setDirectionId("");
            } else {
                rsde.setDirectionId(routeShape.getDirectionId());
            }
            rsde.setType(routeShape.getType());
            this.routeShapeKeyToEncodedShape.put(rsde, routeShape.getEncodedShape());
            if (!this.routeIdToDirectionAndShape.containsKey(routeShape.getRouteId())) {
                this.routeIdToDirectionAndShape.put(rsde.getRouteId(), new HashMap());
            }
            this.routeIdToDirectionAndShape.get(rsde.getRouteId()).put(this.nullSafeGet(routeShape.getDirectionId()), routeShape.getEncodedShape());
        }
    }

    private String nullSafeGet(String directionId) {
        if (directionId == null) {
            return "";
        }
        return directionId;
    }

    private void indexRouteStops() {
        HashedMap routeAndDirectionIdListMap = new HashedMap();
        for (RouteStop routeStop : this._gtfsDao.getAllRouteStops()) {
            AgencyAndId routeId;
            block10: {
                routeId = null;
                try {
                    routeId = AgencyAndIdLibrary.convertFromString((String)routeStop.getRouteId(), (char)':');
                    if (routeAndDirectionIdListMap.containsKey(this.createKey(routeId, routeStop.getDirectionId()))) break block10;
                    RouteStopCollectionEntry rsce = new RouteStopCollectionEntry();
                    rsce.setId(routeStop.getDirectionId());
                    if (rsce.getName() == null) {
                        if (StringUtils.isEmpty((Object)routeStop.getName())) {
                            rsce.setName(routeStop.getRouteId());
                        } else {
                            rsce.setName(routeStop.getName());
                        }
                    }
                    rsce.setRouteId(routeId);
                    routeAndDirectionIdListMap.put(this.createKey(routeId, routeStop.getDirectionId()), rsce);
                }
                catch (IllegalStateException ise) {
                    _log.error("illegal route " + routeStop.getRouteId() + " not in AgencyAndId format");
                    continue;
                }
            }
            RouteAndDirectionId key = this.createKey(routeId, routeStop.getDirectionId());
            RouteStopCollectionEntry entry = (RouteStopCollectionEntry)routeAndDirectionIdListMap.get(key);
            if (entry != null) {
                entry.add(routeStop);
                continue;
            }
            _log.error("missing entry for route" + routeId + " and direction " + routeStop.getDirectionId());
        }
        for (RouteAndDirectionId routeAndDirectionId : routeAndDirectionIdListMap.keySet()) {
            RouteStopCollectionEntry routeStopCollectionEntry = (RouteStopCollectionEntry)routeAndDirectionIdListMap.get(routeAndDirectionId);
            if (!this.routeIdToRouteStops.containsKey(routeAndDirectionId.getRouteId())) {
                this.routeIdToRouteStops.put(routeAndDirectionId.getRouteId(), new ArrayList());
            }
            if (routeStopCollectionEntry != null) {
                this.routeIdToRouteStops.get(routeAndDirectionId.getRouteId()).add(routeStopCollectionEntry);
                continue;
            }
            _log.warn("null routeStopCollectionEntry for route " + routeAndDirectionId.getRouteId());
        }
    }

    private RouteAndDirectionId createKey(AgencyAndId id1, String id2) {
        if (id2 == null) {
            id2 = "";
        }
        return new RouteAndDirectionId(id1, id2);
    }

    private static class RouteAndDirectionId {
        private AgencyAndId routeId;
        private String directionId;

        public RouteAndDirectionId(AgencyAndId routeId, String directionId) {
            this.routeId = routeId;
            this.directionId = directionId;
        }

        public AgencyAndId getRouteId() {
            return this.routeId;
        }

        public String getDirectionId() {
            return this.directionId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteAndDirectionId rd = (RouteAndDirectionId)o;
            return Objects.equals(this.routeId, rd.routeId) && Objects.equals(this.directionId, rd.directionId);
        }

        public int hashCode() {
            int hashcode = 43;
            if (this.routeId != null) {
                hashcode += this.routeId.hashCode();
            }
            if (this.directionId != null) {
                hashcode += this.directionId.hashCode();
            }
            return hashcode;
        }
    }
}

