/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.bundle.tasks;

import java.io.File;
import java.io.IOException;
import org.onebusaway.container.refresh.RefreshService;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.calendar.CalendarServiceData;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalendarServiceDataTask
implements Runnable {
    private GtfsRelationalDao _dao;
    private FederatedTransitDataBundle _bundle;
    private RefreshService _refreshService;
    private int _excludeFutureServiceDatesInDays = 180;

    @Autowired
    public void setGtfsDao(GtfsRelationalDao dao) {
        this._dao = dao;
    }

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Autowired
    public void setRefreshService(RefreshService refreshService) {
        this._refreshService = refreshService;
    }

    public void setExcludeFutureServiceDatesInDays(int excludeFutureServiceDatesInDays) {
        this._excludeFutureServiceDatesInDays = excludeFutureServiceDatesInDays;
    }

    @Override
    public void run() {
        CalendarServiceDataFactoryImpl factory = new CalendarServiceDataFactoryImpl();
        factory.setGtfsDao(this._dao);
        factory.setExcludeFutureServiceDatesInDays(this._excludeFutureServiceDatesInDays);
        CalendarServiceData data = factory.createData();
        data.makeReadOnly();
        try {
            ObjectSerializationLibrary.writeObject((File)this._bundle.getCalendarServiceDataPath(), (Object)data);
            this._refreshService.refresh("calendarData");
        }
        catch (IOException e) {
            throw new IllegalStateException("error serializing service calendar data", e);
        }
    }
}

