/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Polygon2D;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.StringHelper;

final class LatLonPointInPolygonQuery
extends Query {
    final String field;
    final Polygon[] polygons;

    LatLonPointInPolygonQuery(String field, Polygon[] polygons) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (polygons == null) {
            throw new IllegalArgumentException("polygons must not be null");
        }
        if (polygons.length == 0) {
            throw new IllegalArgumentException("polygons must not be empty");
        }
        for (int i = 0; i < polygons.length; ++i) {
            if (polygons[i] != null) continue;
            throw new IllegalArgumentException("polygon[" + i + "] must not be null");
        }
        this.field = field;
        this.polygons = (Polygon[])polygons.clone();
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        Rectangle box = Rectangle.fromPolygon((Polygon[])this.polygons);
        final byte[] minLat = new byte[4];
        final byte[] maxLat = new byte[4];
        final byte[] minLon = new byte[4];
        final byte[] maxLon = new byte[4];
        NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLatitude((double)box.minLat), (byte[])minLat, (int)0);
        NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLatitude((double)box.maxLat), (byte[])maxLat, (int)0);
        NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLongitude((double)box.minLon), (byte[])minLon, (int)0);
        NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLongitude((double)box.maxLon), (byte[])maxLon, (int)0);
        final Polygon2D tree = Polygon2D.create((Polygon[])this.polygons);
        final GeoEncodingUtils.PolygonPredicate polygonPredicate = GeoEncodingUtils.createPolygonPredicate((Polygon[])this.polygons, (Polygon2D)tree);
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                PointValues values = reader.getPointValues(LatLonPointInPolygonQuery.this.field);
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(LatLonPointInPolygonQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                LatLonPoint.checkCompatible(fieldInfo);
                final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values, LatLonPointInPolygonQuery.this.field);
                values.intersect(new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    public void visit(int docID, byte[] packedValue) {
                        if (polygonPredicate.test(NumericUtils.sortableBytesToInt((byte[])packedValue, (int)0), NumericUtils.sortableBytesToInt((byte[])packedValue, (int)4))) {
                            this.adder.add(docID);
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        if (StringHelper.compare((int)4, (byte[])minPackedValue, (int)0, (byte[])maxLat, (int)0) > 0 || StringHelper.compare((int)4, (byte[])maxPackedValue, (int)0, (byte[])minLat, (int)0) < 0 || StringHelper.compare((int)4, (byte[])minPackedValue, (int)4, (byte[])maxLon, (int)0) > 0 || StringHelper.compare((int)4, (byte[])maxPackedValue, (int)4, (byte[])minLon, (int)0) < 0) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        double cellMinLat = GeoEncodingUtils.decodeLatitude((byte[])minPackedValue, (int)0);
                        double cellMinLon = GeoEncodingUtils.decodeLongitude((byte[])minPackedValue, (int)4);
                        double cellMaxLat = GeoEncodingUtils.decodeLatitude((byte[])maxPackedValue, (int)0);
                        double cellMaxLon = GeoEncodingUtils.decodeLongitude((byte[])maxPackedValue, (int)4);
                        return tree.relate(cellMinLat, cellMaxLat, cellMinLon, cellMaxLon);
                    }
                });
                return new ConstantScoreScorer((Weight)this, this.score(), result.build().iterator());
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public Polygon[] getPolygons() {
        return (Polygon[])this.polygons.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Arrays.hashCode(this.polygons);
        return result;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((LatLonPointInPolygonQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(LatLonPointInPolygonQuery other) {
        return this.field.equals(other.field) && Arrays.equals(this.polygons, other.polygons);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(Arrays.toString(this.polygons));
        return sb.toString();
    }
}

