/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class SubsectionTripTransformStrategy
implements GtfsTransformStrategy {
    private Map<String, List<SubsectionOperation>> _operationsByRouteId = new HashMap<String, List<SubsectionOperation>>();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void addOperation(SubsectionOperation operation) {
        if (operation.getFromStopId() == null && operation.getToStopId() == null) {
            throw new IllegalArgumentException("must specify at least fromStopId or toStopId");
        }
        List<SubsectionOperation> operations = this._operationsByRouteId.get(operation.getRouteId());
        if (operations == null) {
            operations = new ArrayList<SubsectionOperation>();
            this._operationsByRouteId.put(operation.getRouteId(), operations);
        }
        operations.add(operation);
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        ArrayList<Trip> tripsToAdd = new ArrayList<Trip>();
        ArrayList<StopTime> stopTimesToAdd = new ArrayList<StopTime>();
        ArrayList<Trip> tripsToRemove = new ArrayList<Trip>();
        ArrayList stopTimesToRemove = new ArrayList();
        HashSet<AgencyAndId> newShapeIds = new HashSet<AgencyAndId>();
        for (Trip trip : dao.getAllTrips()) {
            String routeId = trip.getRoute().getId().getId();
            List<SubsectionOperation> operations = this._operationsByRouteId.get(routeId);
            if (operations == null) continue;
            List stopTimes = dao.getStopTimesForTrip(trip);
            Map<String, Integer> stopToIndex = this.getStopIndices(stopTimes);
            boolean removeOriginalTrip = false;
            for (SubsectionOperation operation : operations) {
                Integer n;
                Integer n2;
                Integer fromIndex = stopToIndex.get(operation.getFromStopId());
                Integer toIndex = stopToIndex.get(operation.getToStopId());
                if (fromIndex == null && toIndex == null) {
                    if (!operation.removeUnmatchedTrips) continue;
                    removeOriginalTrip = true;
                    continue;
                }
                removeOriginalTrip = true;
                Trip newTrip = new Trip(trip);
                Object id = newTrip.getId().getId();
                if (fromIndex != null) {
                    id = (String)id + "-" + operation.getFromStopId();
                }
                if (toIndex != null) {
                    id = (String)id + "-" + operation.getToStopId();
                }
                if (fromIndex == null) {
                    fromIndex = 0;
                } else if (!operation.isIncludeFromStop()) {
                    n2 = fromIndex;
                    n = fromIndex = Integer.valueOf(fromIndex + 1);
                }
                if (toIndex == null) {
                    toIndex = stopTimes.size() - 1;
                } else if (!operation.isIncludeToStop()) {
                    n2 = toIndex;
                    n = toIndex = Integer.valueOf(toIndex - 1);
                }
                newTrip.setId(new AgencyAndId("1", (String)id));
                tripsToAdd.add(newTrip);
                ArrayList<StopTime> newStopTimes = new ArrayList<StopTime>();
                for (int i = fromIndex.intValue(); i <= toIndex; ++i) {
                    StopTime stopTime = new StopTime((StopTime)stopTimes.get(i));
                    stopTime.setId(Integer.valueOf(0));
                    stopTime.setTrip(newTrip);
                    newStopTimes.add(stopTime);
                }
                this.updateShape(dao, newTrip, newStopTimes, newShapeIds);
                stopTimesToAdd.addAll(newStopTimes);
            }
            if (!removeOriginalTrip) continue;
            tripsToRemove.add(trip);
            stopTimesToRemove.addAll(stopTimes);
        }
        for (StopTime stopTime : stopTimesToRemove) {
            dao.removeEntity((IdentityBean)stopTime);
        }
        for (Trip trip : tripsToRemove) {
            dao.removeEntity((IdentityBean)trip);
        }
        for (Trip trip : tripsToAdd) {
            dao.saveEntity((Object)trip);
        }
        for (StopTime stopTime : stopTimesToAdd) {
            dao.saveEntity((Object)stopTime);
        }
        ((GtfsRelationalDaoImpl)dao).clearAllCaches();
        HashSet shapeIds = new HashSet(dao.getAllShapeIds());
        for (Trip trip : dao.getAllTrips()) {
            shapeIds.remove(trip.getShapeId());
        }
        for (AgencyAndId shapeId : shapeIds) {
            for (ShapePoint point : dao.getShapePointsForShapeId(shapeId)) {
                dao.removeEntity((IdentityBean)point);
            }
        }
    }

    private void updateShape(GtfsMutableRelationalDao dao, Trip trip, List<StopTime> stopTimes, Set<AgencyAndId> newShapeIds) {
        if (stopTimes.size() < 2) {
            trip.setShapeId(null);
            return;
        }
        AgencyAndId shapeId = trip.getShapeId();
        if (shapeId == null || !shapeId.hasValues()) {
            return;
        }
        List points = dao.getShapePointsForShapeId(shapeId);
        if (points.isEmpty()) {
            return;
        }
        StopLocation firstStop = stopTimes.get(0).getStop();
        StopLocation lastStop = stopTimes.get(stopTimes.size() - 1).getStop();
        String id = shapeId.getId() + "-" + firstStop.getId().getId() + "-" + lastStop.getId().getId();
        AgencyAndId newShapeId = new AgencyAndId("1", id);
        trip.setShapeId(newShapeId);
        if (!newShapeIds.add(newShapeId)) {
            return;
        }
        if (!(firstStop instanceof Stop)) {
            throw new Error(firstStop + " must be stop");
        }
        if (!(lastStop instanceof Stop)) {
            throw new Error(firstStop + " must be stop");
        }
        int shapePointFrom = this.getClosestShapePointToStop(points, (Stop)firstStop);
        int shapePointTo = this.getClosestShapePointToStop(points, (Stop)lastStop);
        for (int index = shapePointFrom; index <= shapePointTo; ++index) {
            ShapePoint point = new ShapePoint((ShapePoint)points.get(index));
            point.setId(Integer.valueOf(0));
            point.setShapeId(newShapeId);
            dao.saveEntity((Object)point);
        }
    }

    private int getClosestShapePointToStop(List<ShapePoint> points, Stop stop) {
        int minIndex = -1;
        double minDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < points.size(); ++i) {
            double dy;
            ShapePoint point = points.get(i);
            double dx = point.getLon() - stop.getLon();
            double d = Math.sqrt(dx * dx + (dy = point.getLat() - stop.getLat()) * dy);
            if (!(d < minDistance)) continue;
            minIndex = i;
            minDistance = d;
        }
        return minIndex;
    }

    private Map<String, Integer> getStopIndices(List<StopTime> stopTimes) {
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        int index = 0;
        for (StopTime stopTime : stopTimes) {
            String id = stopTime.getStop().getId().getId();
            if (!indices.containsKey(id)) {
                indices.put(id, index);
            }
            ++index;
        }
        return indices;
    }

    public static class SubsectionOperation {
        private String fromStopId;
        private boolean includeFromStop = true;
        private String toStopId;
        private boolean includeToStop = true;
        private String routeId;
        private boolean removeUnmatchedTrips = false;

        public String getFromStopId() {
            return this.fromStopId;
        }

        public void setFromStopId(String fromStopId) {
            this.fromStopId = fromStopId;
        }

        public boolean isIncludeFromStop() {
            return this.includeFromStop;
        }

        public void setIncludeFromStop(boolean includeFromStop) {
            this.includeFromStop = includeFromStop;
        }

        public String getToStopId() {
            return this.toStopId;
        }

        public void setToStopId(String toStopId) {
            this.toStopId = toStopId;
        }

        public boolean isIncludeToStop() {
            return this.includeToStop;
        }

        public void setIncludeToStop(boolean includeToStop) {
            this.includeToStop = includeToStop;
        }

        public String getRouteId() {
            return this.routeId;
        }

        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        public boolean isRemoveUnmatchedTrips() {
            return this.removeUnmatchedTrips;
        }

        public void setRemoveUnmatchedTrips(boolean removeUnmatchedTrips) {
            this.removeUnmatchedTrips = removeUnmatchedTrips;
        }
    }
}

