/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.CalendarSimplicationLibrary;
import org.onebusaway.gtfs_transformer.updates.TripKey;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;

public class CalendarSimplicationStrategy
implements GtfsTransformStrategy {
    private static Pattern _mergedIdPattern = Pattern.compile("^(.*)_merged_(.*)$");
    @CsvField(ignore=true)
    private CalendarSimplicationLibrary _library = new CalendarSimplicationLibrary();
    @CsvField(optional=true)
    private int minNumberOfWeeksForCalendarEntry;
    @CsvField(optional=true)
    private double dayOfTheWeekInclusionRatio;
    @CsvField(optional=true)
    private boolean undoGoogleTransitDataFeedMergeTool = false;

    public void setMinNumberOfWeeksForCalendarEntry(int minNumberOfWeeksForCalendarEntry) {
        this._library.setMinNumberOfWeeksForCalendarEntry(minNumberOfWeeksForCalendarEntry);
    }

    public void setDayOfTheWeekInclusionRatio(double dayOfTheWeekInclusionRatio) {
        this._library.setDayOfTheWeekInclusionRatio(dayOfTheWeekInclusionRatio);
    }

    public void setUndoGoogleTransitDataFeedMergeTool(boolean undoGoogleTransitDataFeedMergeTool) {
        this.undoGoogleTransitDataFeedMergeTool = undoGoogleTransitDataFeedMergeTool;
    }

    public boolean isUndoGoogleTransitDataFeedMergeTool() {
        return this.undoGoogleTransitDataFeedMergeTool;
    }

    public CalendarSimplicationLibrary getLibrary() {
        return this._library;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        HashMap<Set<AgencyAndId>, AgencyAndId> serviceIdsToUpdatedServiceId = new HashMap<Set<AgencyAndId>, AgencyAndId>();
        Map<AgencyAndId, List<AgencyAndId>> mergeToolIdMapping = this.computeMergeToolIdMapping((GtfsDao)dao);
        for (Route route : dao.getAllRoutes()) {
            Map<TripKey, List<Trip>> tripsByKey = TripKey.groupTripsForRouteByKey(dao, route);
            Map<Set<AgencyAndId>, List<TripKey>> tripKeysByServiceIds = this._library.groupTripKeysByServiceIds(tripsByKey);
            for (Set<AgencyAndId> serviceIds : tripKeysByServiceIds.keySet()) {
                AgencyAndId updatedServiceId = this.createUpdatedServiceId(serviceIdsToUpdatedServiceId, serviceIds);
                for (TripKey tripKey : tripKeysByServiceIds.get(serviceIds)) {
                    AgencyAndId updatedTripId;
                    List<Trip> tripsForKey = tripsByKey.get(tripKey);
                    Trip tripToKeep = tripsForKey.get(0);
                    tripToKeep.setServiceId(updatedServiceId);
                    for (int i = 1; i < tripsForKey.size(); ++i) {
                        Trip trip = tripsForKey.get(i);
                        removeEntityLibrary.removeTrip(dao, trip);
                    }
                    if (!this.undoGoogleTransitDataFeedMergeTool || (updatedTripId = this.computeUpdatedTripIdForMergedTripsIfApplicable(mergeToolIdMapping, tripsForKey)) == null) continue;
                    tripToKeep.setId(updatedTripId);
                }
            }
        }
        CalendarService calendarService = CalendarServiceDataFactoryImpl.createService((GtfsRelationalDao)dao);
        ArrayList<Object> newEntities = new ArrayList<Object>();
        for (Map.Entry entry : serviceIdsToUpdatedServiceId.entrySet()) {
            Set<ServiceDate> allServiceDates = this.getServiceDatesForServiceIds(calendarService, (Set)entry.getKey());
            CalendarSimplicationLibrary.ServiceCalendarSummary summary = this._library.getSummaryForServiceDates(allServiceDates);
            this._library.computeSimplifiedCalendar((AgencyAndId)entry.getValue(), summary, newEntities);
        }
        this.saveUpdatedCalendarEntities(dao, newEntities);
    }

    private AgencyAndId createUpdatedServiceId(Map<Set<AgencyAndId>, AgencyAndId> serviceIdsToUpdatedServiceId, Set<AgencyAndId> serviceIds) {
        AgencyAndId updatedServiceId = serviceIdsToUpdatedServiceId.get(serviceIds);
        if (updatedServiceId == null) {
            if (serviceIds.isEmpty()) {
                throw new IllegalStateException();
            }
            ArrayList<AgencyAndId> toSort = new ArrayList<AgencyAndId>(serviceIds);
            Collections.sort(toSort);
            StringBuilder b = new StringBuilder();
            String agencyId = null;
            for (int i = 0; i < toSort.size(); ++i) {
                AgencyAndId serviceId = (AgencyAndId)toSort.get(i);
                if (i == 0) {
                    agencyId = serviceId.getAgencyId();
                } else {
                    b.append("-");
                }
                b.append(serviceId.getId());
            }
            updatedServiceId = new AgencyAndId(agencyId, b.toString());
            serviceIdsToUpdatedServiceId.put(serviceIds, updatedServiceId);
        }
        return updatedServiceId;
    }

    private Map<AgencyAndId, List<AgencyAndId>> computeMergeToolIdMapping(GtfsDao dao) {
        if (!this.undoGoogleTransitDataFeedMergeTool) {
            return Collections.emptyMap();
        }
        FactoryMap mergedIdMapping = new FactoryMap(new ArrayList());
        FactoryMap unmergedIdMapping = new FactoryMap(new ArrayList());
        for (Trip trip : dao.getAllTrips()) {
            AgencyAndId tripId = trip.getId();
            AgencyAndId unmergedTripId = this.computeUnmergedTripId(tripId);
            if (unmergedTripId.equals((Object)tripId)) {
                ((List)unmergedIdMapping.get(unmergedTripId)).add(tripId);
                continue;
            }
            ((List)mergedIdMapping.get(unmergedTripId)).add(tripId);
        }
        HashSet intersection = new HashSet(mergedIdMapping.keySet());
        intersection.retainAll(unmergedIdMapping.keySet());
        if (!intersection.isEmpty()) {
            throw new IllegalStateException("some ids appeared both in the merged and unmerged case: " + intersection);
        }
        mergedIdMapping.putAll(unmergedIdMapping);
        return mergedIdMapping;
    }

    private AgencyAndId computeUpdatedTripIdForMergedTripsIfApplicable(Map<AgencyAndId, List<AgencyAndId>> mergeToolIdMapping, List<Trip> trips) {
        AgencyAndId unmergedTripId = null;
        for (Trip trip : trips) {
            AgencyAndId id = this.computeUnmergedTripId(trip.getId());
            if (unmergedTripId == null) {
                unmergedTripId = id;
                continue;
            }
            if (unmergedTripId.equals((Object)id)) continue;
            return null;
        }
        List<AgencyAndId> originalIds = mergeToolIdMapping.get(unmergedTripId);
        if (originalIds == null || originalIds.size() != trips.size()) {
            return null;
        }
        return unmergedTripId;
    }

    private AgencyAndId computeUnmergedTripId(AgencyAndId tripId) {
        Matcher m = _mergedIdPattern.matcher(tripId.getId());
        if (m.matches()) {
            return new AgencyAndId(tripId.getAgencyId(), m.group(1));
        }
        return tripId;
    }

    private Set<ServiceDate> getServiceDatesForServiceIds(CalendarService calendarService, Set<AgencyAndId> serviceIds) {
        HashSet<ServiceDate> allServiceDates = new HashSet<ServiceDate>();
        for (AgencyAndId serviceId : serviceIds) {
            Set serviceDates = calendarService.getServiceDatesForServiceId(serviceId);
            allServiceDates.addAll(serviceDates);
        }
        return allServiceDates;
    }

    private void saveUpdatedCalendarEntities(GtfsMutableRelationalDao dao, List<Object> newEntities) {
        dao.clearAllEntitiesForType(ServiceCalendar.class);
        dao.clearAllEntitiesForType(ServiceCalendarDate.class);
        for (Object entity : newEntities) {
            dao.saveEntity(entity);
        }
        UpdateLibrary.clearDaoCache((GtfsRelationalDao)dao);
    }
}

