/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import gov.wa.wsdot.ferries.schedule.SchedResponse;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WSFScheduleService {
    private static Logger _log = LoggerFactory.getLogger(WSFScheduleService.class);
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    private String _apiAccessCode;
    JAXBContext _jc = JAXBContext.newInstance((Class[])new Class[]{SchedResponse.class});

    public WSFScheduleService(String apiAccessCode) throws JAXBException {
        this._apiAccessCode = apiAccessCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedResponse getSchedule(Date serviceDate, String departTerminal, String arriveTerminal) {
        SchedResponse schedResponse;
        long start = System.currentTimeMillis();
        StringBuffer url = new StringBuffer("https://www.wsdot.wa.gov/ferries/api/schedule/rest/schedule");
        url.append("/" + WSFScheduleService.formatDate(serviceDate));
        url.append("/" + departTerminal);
        url.append("/" + arriveTerminal);
        url.append("?apiaccesscode=" + this._apiAccessCode);
        URLConnection conn = new URL(url.toString()).openConnection();
        conn.setRequestProperty("Accept", "text/xml");
        InputStream is = conn.getInputStream();
        try {
            JAXBElement resp = this._jc.createUnmarshaller().unmarshal((Source)new StreamSource(is), SchedResponse.class);
            schedResponse = (SchedResponse)resp.getValue();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                long finish = System.currentTimeMillis();
                _log.info("wsf call complete in " + (finish - start) / 1000L + "s for call=" + url);
                throw throwable;
            }
            catch (Exception e) {
                _log.error("Exception processing WSF API for api call:'" + url.toString() + "', " + e);
                return null;
            }
        }
        is.close();
        long finish = System.currentTimeMillis();
        _log.info("wsf call complete in " + (finish - start) / 1000L + "s for call=" + url);
        return schedResponse;
    }

    private static String formatDate(Date date) {
        return DATE_FORMATTER.format(date);
    }
}

